/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.data.HashStructure;

class NodeConversionRecognizerHookHelper {
    static Map<String, Set<String>> findNodeConversions(HashStructure hs) {
        return Collections.unmodifiableMap(NodeConversionRecognizerHookHelper.buildNodeConversions(hs));
    }

    private static Map<String, Set<String>> buildNodeConversions(HashStructure hs) {
        HashMap<String, Set<String>> conversions = new HashMap<String, Set<String>>();
        List nodeConversions = hs.getAsList("node-conversions");
        if (nodeConversions == null) {
            return conversions;
        }
        for (Object o : nodeConversions) {
            HashStructure childHs;
            List hsList;
            if (!(o instanceof HashStructure) || (hsList = (childHs = (HashStructure)o).getAsList("node-conversion")) == null) continue;
            NodeConversionRecognizerHookHelper.addNodeConversions(hsList, conversions);
        }
        return conversions;
    }

    private static void addNodeConversions(List hsList, Map<String, Set<String>> conversions) {
        for (Object o : hsList) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure hs = (HashStructure)o;
            String oldType = hs.getString("old-type/#text");
            String newType = hs.getString("new-type/#text");
            Set<String> newTypes = conversions.get(oldType);
            if (newTypes == null) {
                newTypes = new HashSet<String>();
                conversions.put(oldType, newTypes);
            }
            newTypes.add(newType);
        }
    }

    private NodeConversionRecognizerHookHelper() {
    }
}

