/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.model.FacadeTextBuffer;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

class FacadeTextBufferListeners
extends CopyOnWriteArrayList<TextBufferListener>
implements TextBufferListener {
    private static final Logger LOG = Logger.getLogger(TextBuffer.class.getName());
    private TextNode node;

    public FacadeTextBufferListeners(TextNode node) {
        this.node = node;
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        if (!this.node.isLoading()) {
            this.node.setTimestampDirectly(System.currentTimeMillis());
        }
        FacadeTextBuffer facadeBuffer = this.node.facadeBuffer();
        facadeBuffer.throwIfExpired();
        for (TextBufferListener listener : this) {
            try {
                listener.insertUpdate((TextBuffer)facadeBuffer, offset, count, insertedData);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " inserting " + insertedData.length + " at " + offset, e);
            }
        }
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        if (!this.node.isLoading()) {
            this.node.setTimestampDirectly(System.currentTimeMillis());
        }
        FacadeTextBuffer facadeBuffer = this.node.facadeBuffer();
        facadeBuffer.throwIfExpired();
        for (TextBufferListener listener : this) {
            try {
                listener.removeUpdate((TextBuffer)facadeBuffer, offset, count, removedData);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " removing " + removedData.length + " from " + offset, e);
            }
        }
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        if (!this.node.isLoading() && attribute == 5) {
            this.node.markDirty(buffer.isModified());
        }
        FacadeTextBuffer facadeBuffer = this.node.facadeBuffer();
        facadeBuffer.throwIfExpired();
        for (TextBufferListener listener : this) {
            try {
                listener.attributeUpdate((TextBuffer)facadeBuffer, attribute);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " updating attribute " + attribute, e);
            }
        }
    }

    final boolean addWeakTextBufferListener(TextBufferListener listener) {
        if (listener == null) {
            return false;
        }
        return this.addIfAbsent(new WeakTBListener(listener));
    }

    final boolean removeWeakTextBufferListener(TextBufferListener listener) {
        if (listener == null) {
            return false;
        }
        return this.remove(new WeakTBListener(listener));
    }

    private final class WeakTBListener
    implements TextBufferListener {
        private WeakReference<TextBufferListener> weakListener;

        public WeakTBListener(TextBufferListener listener) {
            this.weakListener = new WeakReference<TextBufferListener>(listener);
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            TextBufferListener listener = (TextBufferListener)this.weakListener.get();
            if (listener == null) {
                FacadeTextBufferListeners.this.remove(this);
            } else {
                listener.insertUpdate(buffer, offset, count, insertedData);
            }
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            TextBufferListener listener = (TextBufferListener)this.weakListener.get();
            if (listener == null) {
                FacadeTextBufferListeners.this.remove(this);
            } else {
                listener.removeUpdate(buffer, offset, count, removedData);
            }
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            TextBufferListener listener = (TextBufferListener)this.weakListener.get();
            if (listener == null) {
                FacadeTextBufferListeners.this.remove(this);
            } else {
                listener.attributeUpdate(buffer, attribute);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof WeakTBListener)) {
                return false;
            }
            WeakTBListener other = (WeakTBListener)object;
            TextBufferListener thisTextBufferListener = (TextBufferListener)this.weakListener.get();
            TextBufferListener otherTextBufferListener = (TextBufferListener)other.weakListener.get();
            return thisTextBufferListener != null ? thisTextBufferListener.equals(otherTextBufferListener) : otherTextBufferListener == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            TextBufferListener textBufferListener = (TextBufferListener)this.weakListener.get();
            result = 37 * result + (textBufferListener == null ? 0 : textBufferListener.hashCode());
            return result;
        }
    }
}

