/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.ide.model.FacadeTextBuffer;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.Log;

class FacadeBufferReference
extends WeakReference<FacadeTextBuffer>
implements Runnable {
    private static final Logger LOG = Logger.getLogger(TextBuffer.class.getName());
    private static final Log EXPIRATION_LOG = new Log(new String[]{"expiration", "expiration-detail"});
    private static final Log EXPIRATION_DETAIL_LOG = new Log("expiration-detail");
    private static ReferenceQueue<FacadeTextBuffer> queue;
    private TextNode node;

    public FacadeBufferReference(TextNode node, FacadeTextBuffer buffer) {
        super(buffer, FacadeBufferReference.getQueue());
        this.node = node;
        EXPIRATION_LOG.trace("created facade {0}", (Object)this);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.node = null;
    }

    public String toString() {
        return (this.node != null ? this.node.getShortLabel() : "") + "(" + System.identityHashCode(this) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TextNode node;
        FacadeBufferReference facadeBufferReference = this;
        synchronized (facadeBufferReference) {
            node = this.node;
            if (node == null) {
                return;
            }
        }
        ReadWriteLock lock = node.nodeLock();
        if (!lock.isLockHeld() && lock.tryWriteLock()) {
            node.setAutoClosing(true);
            try {
                if (this == node.getFacadeBufferReference() && !node.isDirty()) {
                    EXPIRATION_LOG.trace("auto-closing node {0}", (Object)this);
                    node.close();
                    EXPIRATION_LOG.trace("auto-closed node {0}", (Object)this);
                }
                EXPIRATION_LOG.trace("skipped auto-closing dirty node {0}", (Object)this);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unexpected exception auto-closing " + node, e);
                EXPIRATION_LOG.trace("closing facade reference {0} failed: {1}", (Object)this, (Object)e);
            }
            finally {
                node.setAutoClosing(false);
                lock.writeUnlock();
            }
        } else if (EXPIRATION_DETAIL_LOG.isEnabled()) {
            StringBuilder buffer = new StringBuilder();
            lock.appendSnapshot(buffer);
            EXPIRATION_DETAIL_LOG.trace("auto-closing node {0} failed because lock was unavailable:\n{0}", (Object)buffer);
        } else {
            EXPIRATION_LOG.trace("auto-closing node {0} failed because lock was unavailable", (Object)this);
        }
    }

    private static final synchronized ReferenceQueue<FacadeTextBuffer> getQueue() {
        if (queue == null) {
            queue = new ReferenceQueue();
            new PollingThread().start();
        }
        return queue;
    }

    private static final class PollingThread
    extends Thread {
        public PollingThread() {
            super("TextBufferScavenger");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        FacadeBufferReference referer = (FacadeBufferReference)queue.remove();
                        EXPIRATION_LOG.trace("dequed facade reference {0}", (Object)referer);
                        SwingUtilities.invokeLater(referer);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

