/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.GuardedTextBufferListener;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.NullArgumentException;

final class ExpiredTextBuffer
extends GuardedTextBuffer {
    private ReadWriteLock lock;
    private boolean autoClosed;
    private Throwable disposeTrace;
    private long disposeTime;
    private static final long ONE_MILLISECOND = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    private static final long ONE_SECOND = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);

    public ExpiredTextBuffer(ReadWriteLock lock, boolean autoClosed) {
        super(null);
        this.lock = lock;
        this.autoClosed = autoClosed;
        this.disposeTrace = new Throwable("expiration origin");
        this.disposeTime = System.nanoTime();
    }

    ExpiredTextBufferException newExpiredTextBufferException() {
        long nanoInterval = System.nanoTime() - this.disposeTime;
        String interval = nanoInterval < ONE_MILLISECOND ? String.valueOf(nanoInterval) + "us" : (nanoInterval < ONE_SECOND ? String.valueOf(TimeUnit.MILLISECONDS.convert(nanoInterval, TimeUnit.NANOSECONDS)) + "ms" : String.valueOf(TimeUnit.SECONDS.convert(nanoInterval, TimeUnit.NANOSECONDS)) + "s");
        String message = this.lock.getName() + " expired " + interval + (this.autoClosed ? " ago (auto-closed)" : " ago");
        return new ExpiredTextBufferException(message, this.disposeTrace);
    }

    public void addTextBufferListener(TextBufferListener listener) {
        throw this.newExpiredTextBufferException();
    }

    public void removeTextBufferListener(TextBufferListener listener) {
    }

    public OffsetMark addOffsetMark(int offset) {
        throw this.newExpiredTextBufferException();
    }

    public OffsetMark addOffsetMark(int offset, boolean bias) {
        throw this.newExpiredTextBufferException();
    }

    public void removeOffsetMark(OffsetMark offsetMark) {
    }

    public UndoableEdit append(char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
        throw this.newExpiredTextBufferException();
    }

    public void beginEdit() throws ReadOnlyException {
        throw this.newExpiredTextBufferException();
    }

    public void clearModified() {
        throw this.newExpiredTextBufferException();
    }

    public UndoableEdit endEdit() {
        throw this.newExpiredTextBufferException();
    }

    public int getChangeId() {
        throw this.newExpiredTextBufferException();
    }

    public String getEOLType() {
        throw this.newExpiredTextBufferException();
    }

    public LineMap getLineMap() {
        throw this.newExpiredTextBufferException();
    }

    public String getPlatformEOLType() {
        throw this.newExpiredTextBufferException();
    }

    public UndoableEdit insert(int offset, char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
        throw this.newExpiredTextBufferException();
    }

    public UndoableEdit insert(int offset, Reader reader) throws IndexOutOfBoundsException, IOException, ReadOnlyException {
        throw this.newExpiredTextBufferException();
    }

    public boolean isModified() {
        throw this.newExpiredTextBufferException();
    }

    public boolean isReadOnly() {
        throw this.newExpiredTextBufferException();
    }

    public void read(Reader reader) throws IOException {
        throw this.newExpiredTextBufferException();
    }

    public UndoableEdit remove(int offset, int count) throws IndexOutOfBoundsException, ReadOnlyException {
        throw this.newExpiredTextBufferException();
    }

    public UndoableEdit removeToEnd(int offset) throws IndexOutOfBoundsException, ReadOnlyException {
        throw this.newExpiredTextBufferException();
    }

    public void setEOLType(String eolType) throws ReadOnlyException {
        throw this.newExpiredTextBufferException();
    }

    public void setReadOnly(boolean readOnly) {
        throw this.newExpiredTextBufferException();
    }

    public void write(Writer writer) {
        throw this.newExpiredTextBufferException();
    }

    public void write(Writer writer, boolean clearModified) {
        throw this.newExpiredTextBufferException();
    }

    public int getLength() {
        throw this.newExpiredTextBufferException();
    }

    public char getChar(int offset) {
        throw this.newExpiredTextBufferException();
    }

    public char[] getChars(int offset, int length) {
        throw this.newExpiredTextBufferException();
    }

    public String getString(int offset, int length) {
        throw this.newExpiredTextBufferException();
    }

    public void getText(int offset, int length, Segment segment) {
        throw this.newExpiredTextBufferException();
    }

    public void unguard(int offset, int length) {
        throw this.newExpiredTextBufferException();
    }

    public void setGuardActive(boolean isGuardActive) {
        throw this.newExpiredTextBufferException();
    }

    public boolean isOffsetGuarded(int offset) {
        throw this.newExpiredTextBufferException();
    }

    public boolean isGuardActive() {
        throw this.newExpiredTextBufferException();
    }

    public void guard(int offset, int length) {
        throw this.newExpiredTextBufferException();
    }

    public void addGuardedTextBufferListener(GuardedTextBufferListener listener) {
        throw this.newExpiredTextBufferException();
    }

    public void writeLock() throws ReadOnlyException {
        this.lock.writeLock();
    }

    public void writeLockInterruptibly() throws InterruptedException, ReadOnlyException {
        this.lock.writeLockInterruptibly();
    }

    public void writeLock(boolean checkIfReadOnly) throws ReadOnlyException {
        this.lock.writeLock();
    }

    public boolean tryWriteLock() throws ReadOnlyException {
        return this.lock.tryWriteLock();
    }

    public void writeUnlock() {
        this.lock.writeUnlock();
    }

    public void readLock() {
        this.lock.readLock();
    }

    public void readLockInterruptibly() throws InterruptedException {
        this.lock.readLockInterruptibly();
    }

    public int getLockStatus() {
        if (this.lock.isWriteLockHeld()) {
            return 2;
        }
        if (this.lock.isReadLockHeld()) {
            return 1;
        }
        return 0;
    }

    public boolean tryReadLock() {
        return this.lock.tryReadLock();
    }

    public void readUnlock() {
        this.lock.readUnlock();
    }

    public boolean addWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        return this.lock.addWriteLockRequestListener(listener);
    }

    public void removeWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        this.lock.removeWriteLockRequestListener(listener);
    }
}

