/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ResourceBundle;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.model.Node;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.GraphicsUtils;

public final class DocumentInfo {
    private Icon icon;
    private String label;
    private ResourceBundle bundle;
    private int key = -1;
    private String strKey;
    private MetaClass iconNodeClass;
    private boolean hidden;

    public DocumentInfo(String label) {
        this(label, false);
    }

    public DocumentInfo(String label, boolean hidden) {
        this.label = label;
        this.hidden = hidden;
    }

    public DocumentInfo(String label, Icon icon) {
        this.label = label;
        this.icon = icon;
    }

    public DocumentInfo(String label, ArrayResourceBundle bundle, int key) {
        this.label = label;
        this.bundle = key >= 0 ? bundle : null;
        this.key = key;
    }

    public DocumentInfo(String label, ResourceBundle bundle, String key) {
        this.label = label;
        this.bundle = key != null ? bundle : null;
        this.strKey = key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isIconSpecified() {
        return this.icon != null || this.bundle != null || this.iconNodeClass != null;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            if (this.bundle != null) {
                if (this.key >= 0) {
                    this.icon = ((ArrayResourceBundle)this.bundle).getIconImpl(this.key);
                } else {
                    try {
                        ImageIcon imageIcon;
                        Image image;
                        URL url = this.bundle.getClass().getResource(this.strKey);
                        if (url != null && (image = Toolkit.getDefaultToolkit().createImage(url)) != null && (imageIcon = GraphicsUtils.createImageIcon((Image)image)).getImageLoadStatus() == 8) {
                            this.icon = imageIcon;
                        }
                    }
                    catch (Exception e) {
                        this.icon = null;
                    }
                }
                this.resetBundle();
            } else if (this.iconNodeClass != null) {
                try {
                    Node node = (Node)this.iconNodeClass.newInstance();
                    this.icon = node.getIcon();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.icon == null) {
                    this.icon = ModelArb.getIcon(15);
                }
                this.resetBundle();
            }
        }
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.resetBundle();
    }

    public void setIcon(ArrayResourceBundle bundle, int key) {
        this.icon = null;
        this.bundle = key >= 0 ? bundle : null;
        this.key = key;
        this.strKey = null;
    }

    public void setIcon(ResourceBundle bundle, String key) {
        this.icon = null;
        this.bundle = key != null ? bundle : null;
        this.strKey = key;
        this.key = -1;
    }

    public void setIcon(Class iconNodeClass) {
        this.icon = null;
        this.resetBundle();
        this.iconNodeClass = MetaClass.newMetaClass((Class)iconNodeClass);
    }

    public void setIconMetaClass(MetaClass iconMetaClass) {
        this.icon = null;
        this.resetBundle();
        this.iconNodeClass = iconMetaClass;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    private void resetBundle() {
        this.bundle = null;
        this.key = -1;
        this.strKey = null;
        this.iconNodeClass = null;
    }
}

