/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import javax.ide.util.MetaClass;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.panels.Navigable;
import oracle.ide.util.Assert;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;

public class ContentSetProviderReference {
    private final String label;
    private final String navigableLabel;
    private final String key;
    private final boolean defaultContentSet;
    private final boolean showInDefaultProject;
    private final boolean applicationLevelContent;
    private final boolean displayFoldersAsPackages;
    private final boolean canContainJavaSources;
    private final boolean flatLevelEnabled;
    private final boolean alwaysShowEmptyFolders;
    private final MetaClass<ContentSetProvider> type;
    private String extensionId;
    private final PatternFilters patternFilters;
    private final String defaultSourceFolder;
    private PatternFilters noAutoExpandFilters;
    @GuardedBy(value="this")
    private ContentSetProvider instance;

    public ContentSetProviderReference(ContentSetProvider provider) {
        this.label = provider.getShortLabel();
        Navigable navigable = provider.getNavigable();
        this.navigableLabel = navigable != null ? navigable.getShortLabel() : "";
        this.key = provider.getKey();
        this.defaultContentSet = false;
        this.showInDefaultProject = true;
        this.applicationLevelContent = provider.applicationLevelContent();
        this.displayFoldersAsPackages = provider.displayFoldersAsPackages();
        this.canContainJavaSources = provider.canContainJavaSources();
        this.flatLevelEnabled = provider.isFlatLevelEnabled();
        this.alwaysShowEmptyFolders = provider.alwaysShowEmptyFolders();
        this.type = null;
        this.instance = provider;
        this.patternFilters = null;
        this.defaultSourceFolder = null;
    }

    public ContentSetProviderReference(String label, String navigableLabel, String key, boolean isDefaultContentSet, boolean showInDefaultProject, boolean applicationLevelContent, boolean displayFoldersAsPackages, boolean canContainJavaSources, boolean flatLevelEnabled, boolean alwaysShowEmptyFolders, MetaClass<ContentSetProvider> type, String defaultSourceFolder, PatternFilters patternFilters) {
        this.label = label;
        this.navigableLabel = navigableLabel;
        this.key = key;
        this.defaultContentSet = isDefaultContentSet;
        this.showInDefaultProject = showInDefaultProject;
        this.applicationLevelContent = applicationLevelContent;
        this.displayFoldersAsPackages = displayFoldersAsPackages;
        this.canContainJavaSources = canContainJavaSources;
        this.flatLevelEnabled = flatLevelEnabled;
        this.alwaysShowEmptyFolders = alwaysShowEmptyFolders;
        this.type = type;
        this.defaultSourceFolder = defaultSourceFolder;
        this.patternFilters = patternFilters;
    }

    public String label() {
        return this.label;
    }

    public String navigableLabel() {
        return this.navigableLabel;
    }

    public boolean hasNavigable() {
        return this.navigableLabel != null && this.navigableLabel.length() > 0;
    }

    public String key() {
        return this.key;
    }

    public boolean applicationLevelContent() {
        return this.applicationLevelContent;
    }

    public boolean isDefaultContentSet() {
        return this.hasNavigable() && this.defaultContentSet;
    }

    public boolean isShowInDefaultProject() {
        return this.showInDefaultProject;
    }

    public boolean displayFoldersAsPackages() {
        return this.displayFoldersAsPackages;
    }

    public boolean alwaysShowEmptyFolders() {
        return this.alwaysShowEmptyFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentSetProvider contentSetProvider() {
        ContentSetProvider p = null;
        ContentSetProviderReference contentSetProviderReference = this;
        synchronized (contentSetProviderReference) {
            p = this.instance;
        }
        if (p != null) {
            return p;
        }
        return this.createContentSetProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlreadyInitialized() {
        ContentSetProviderReference contentSetProviderReference = this;
        synchronized (contentSetProviderReference) {
            return this.instance != null;
        }
    }

    public boolean canContainJavaSources() {
        return this.canContainJavaSources;
    }

    public boolean isFlatLevelEnabled() {
        return this.flatLevelEnabled;
    }

    private synchronized ContentSetProvider createContentSetProvider() {
        try {
            this.instance = (ContentSetProvider)this.type.newInstance();
            this.instance.setKey(this.key);
            return this.instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate ContentSetProvider", e);
        }
    }

    public void extensionId(String extensionId) {
        this.extensionId = extensionId;
    }

    public String extensionId() {
        return this.extensionId;
    }

    public void initContentSet(ContentSet contentSet, URL projectDir, Context context) {
        if (this.defaultSourceFolder != null && this.patternFilters != null) {
            URLPath urlPath = contentSet.getURLPath();
            if (urlPath.size() == 0) {
                urlPath.add(URLFactory.newDirURL((URL)projectDir, (String)this.defaultSourceFolder));
            }
            Assert.printStackTrace((this.patternFilters.getFilters() == null ? 1 : 0) != 0, (String)"No pattern filters defined");
            if (this.patternFilters.getFilters() != null) {
                PatternFilters contentSetFilters = contentSet.getPatternFilters();
                for (PatternFilter f : this.patternFilters.getFilters()) {
                    if (f.isInclude()) {
                        contentSetFilters.addInclude(f.getPattern());
                        continue;
                    }
                    contentSetFilters.addExclude(f.getPattern());
                }
            }
        }
        contentSet.setNoAutoexpandFilters(this.noAutoExpandFilters);
    }

    void setNoAutoexpandFilters(PatternFilters noAexFilters) {
        this.noAutoExpandFilters = noAexFilters;
    }

    PatternFilters getNoAutoexpandFilters() {
        return this.noAutoExpandFilters;
    }
}

