/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.Comparator;
import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;

final class ShortcutElement {
    final KeyStrokeMap _map;
    final KeyStrokes _kss;
    String _sortable;
    static final Comparator<ShortcutElement> COMPARATOR = new ShortcutElementComparator();

    ShortcutElement(KeyStrokeMap map, KeyStrokes kss) {
        this._map = map;
        this._kss = kss;
    }

    public final String toString() {
        return this._kss.toString();
    }

    private final String toSortableString() {
        if (this._sortable == null) {
            if (this._kss.isEmpty()) {
                this._sortable = "";
                return "";
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this._kss.getData().size(); ++i) {
                KeyStroke keyStroke = this._kss.getKeyStroke(i);
                b.append(KeyUtil.toSortableString(keyStroke));
            }
            this._sortable = b.toString();
        }
        return this._sortable;
    }

    private static class ShortcutElementComparator
    implements Comparator<ShortcutElement> {
        private ShortcutElementComparator() {
        }

        @Override
        public int compare(ShortcutElement o1, ShortcutElement o2) {
            return o1.toSortableString().compareTo(o2.toSortableString());
        }
    }
}

