/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.util.Assert;
import oracle.javatools.util.Pair;

public final class KeyStrokeMap
implements Serializable {
    private final HashMap<KeyStrokes, Integer> _map = new HashMap();
    private final List<Pair<Integer, KeyStrokes>> _list = new ArrayList<Pair<Integer, KeyStrokes>>();
    private List<Pair<KeyStrokes, String>> _postponedLoad;

    public KeyStrokeMap cloneObject() {
        KeyStrokeMap clone = new KeyStrokeMap();
        clone.assign(this);
        return clone;
    }

    public void assign(KeyStrokeMap source) {
        this.removeAll();
        this.putAll(source);
        if (source._postponedLoad != null) {
            this._postponedLoad = new ArrayList<Pair<KeyStrokes, String>>(source._postponedLoad);
        }
    }

    private Integer getBindAt(int nPos) {
        Pair<Integer, KeyStrokes> pair = this._list.get(nPos);
        return (Integer)pair.first;
    }

    private KeyStrokes getKeyStrokesAt(int nPos) {
        Pair<Integer, KeyStrokes> pair = this._list.get(nPos);
        return (KeyStrokes)pair.second;
    }

    private int binarySearchAny(int bind) {
        int low = 0;
        int high = this._list.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int midVal = this.getBindAt(mid);
            if (midVal < bind) {
                low = mid + 1;
                continue;
            }
            if (midVal > bind) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private int binarySearchFirst(int bind) {
        int nPos;
        for (nPos = this.binarySearchAny(bind); nPos > 0 && this.getBindAt(nPos - 1) == bind; --nPos) {
        }
        return nPos;
    }

    public boolean put(KeyStrokes key, Integer bind) {
        boolean ret = false;
        if (!this._map.containsKey(key)) {
            int nPos = this.binarySearchFirst(bind);
            if (nPos >= 0) {
                int n = this._list.size();
                while (nPos < n && this.getBindAt(nPos).equals(bind)) {
                    ++nPos;
                }
            } else {
                nPos = -nPos - 1;
            }
            this._list.add(nPos, (Pair<Integer, KeyStrokes>)new Pair((Object)bind, (Object)key));
            this._map.put(key, bind);
            ret = true;
        }
        return ret;
    }

    public void putAll(KeyStrokeMap ksm) {
        int n = ksm._list.size();
        for (int i = 0; i < n; ++i) {
            Integer bind = ksm.getBindAt(i);
            KeyStrokes kss = ksm.getKeyStrokesAt(i);
            this.put(kss, bind);
        }
    }

    public void removeAll(KeyStrokeMap ksm) {
        int n = ksm._list.size();
        for (int i = 0; i < n; ++i) {
            KeyStrokes kss = ksm.getKeyStrokesAt(i);
            this.remove(kss);
        }
    }

    void removeAll() {
        this._list.clear();
        this._map.clear();
    }

    public void remove(KeyStrokes key) {
        Iterator<Pair<Integer, KeyStrokes>> i = this._list.iterator();
        while (i.hasNext()) {
            Pair<Integer, KeyStrokes> pair = i.next();
            KeyStrokes kss = (KeyStrokes)pair.second;
            if (!key.equals(kss)) continue;
            i.remove();
        }
        this._map.remove(key);
    }

    public Set<KeyStrokes> keySet() {
        return this._map.keySet();
    }

    public Collection<Integer> values() {
        return this._map.values();
    }

    public List<KeyStrokes> getKeyStrokesFor(Integer bind) {
        return this.getKeyStrokesFor((int)bind);
    }

    public List<KeyStrokes> getKeyStrokesFor(int bind) {
        ArrayList<KeyStrokes> list = null;
        int nPos = this.binarySearchFirst(bind);
        if (nPos >= 0) {
            int n = this._list.size();
            while (nPos < n && this.getBindAt(nPos) == bind) {
                if (list == null) {
                    list = new ArrayList<KeyStrokes>(1);
                }
                list.add(this.getKeyStrokesAt(nPos));
                ++nPos;
            }
        }
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public Integer getBindingFor(KeyStrokes kss) {
        return this._map.get(kss);
    }

    Collection<KeyStroke> getMultikeyKeystrokes() {
        HashSet<KeyStroke> ret = new HashSet<KeyStroke>();
        for (int i = 0; i < this._list.size(); ++i) {
            KeyStrokes keyStrokes = this.getKeyStrokesAt(i);
            int length = keyStrokes.getLength();
            for (int j = 0; j < length - 1; ++j) {
                ret.add(keyStrokes.getKeyStroke(j));
            }
        }
        return ret;
    }

    public List<KeyStrokes> getKeyStrokesStartingWith(KeyStrokes kss) {
        ArrayList<KeyStrokes> l = new ArrayList<KeyStrokes>();
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            KeyStrokes kss2 = this.getKeyStrokesAt(i);
            if (!kss2.startWith(kss)) continue;
            l.add(kss2);
        }
        return l;
    }

    public ArrayList getData() {
        ArrayList<Pair> data = new ArrayList<Pair>();
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            KeyStrokes kss = this.getKeyStrokesAt(i);
            Integer cmdId = this.getBindAt(i);
            if (cmdId == null) continue;
            String cmd = Ide.findCmdName(cmdId);
            if (cmd != null) {
                data.add(new Pair((Object)cmd, (Object)kss));
                continue;
            }
            Assert.println((String)("Cannot save accelerator for cmdId " + cmdId + " (command name not found"));
        }
        if (this._postponedLoad != null) {
            for (Pair<KeyStrokes, String> p : this._postponedLoad) {
                data.add(new Pair(p.second, p.first));
            }
        }
        return data;
    }

    public void setData(ArrayList data) {
        if (data != null) {
            this.removeAll();
            int n = data.size();
            for (int i = 0; i < n; ++i) {
                Pair pair = (Pair)data.get(i);
                KeyStrokes kss = (KeyStrokes)pair.second;
                if (kss == null || !kss.isValid()) continue;
                String cmdName = (String)pair.first;
                this.addPostponedLoad(kss, cmdName);
            }
        }
    }

    boolean addMap(KeyStrokes kss, String cmdName) {
        Integer cmdID = Ide.findCmdID(cmdName);
        if (cmdID == null) {
            return false;
        }
        if (!this.put(kss, cmdID)) {
            // empty if block
        }
        return true;
    }

    private void addPostponedLoad(KeyStrokes kss, String cmdName) {
        if (this._postponedLoad == null) {
            this._postponedLoad = new ArrayList<Pair<KeyStrokes, String>>(50);
        }
        this._postponedLoad.add((Pair<KeyStrokes, String>)new Pair((Object)kss, (Object)cmdName));
    }

    public boolean solvePostponedLoad() {
        boolean bAllSolved = true;
        if (this._postponedLoad != null) {
            Iterator<Pair<KeyStrokes, String>> i = this._postponedLoad.iterator();
            while (i.hasNext()) {
                Pair<KeyStrokes, String> p = i.next();
                KeyStrokes kss = (KeyStrokes)p.first;
                String cmdName = (String)p.second;
                if (!this.addMap(kss, cmdName)) continue;
                i.remove();
            }
            if (this._postponedLoad.isEmpty()) {
                this._postponedLoad = null;
            } else {
                bAllSolved = false;
            }
        }
        return bAllSolved;
    }
}

