/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules.functions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.util.Assert;

public class ProjectHasTechScope
extends RuleFunction {
    private static final String PARAM_TECHNOLOGY_KEY = "technology-keys";
    private static final String MATCH_ALL = "all";
    private static final String MATCH_ANY = "any";
    private static final String PARAM_MATCH = "match";

    @Override
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        Project project = ruleContext.getIdeContext().getProject();
        if (project == null) {
            return false;
        }
        TechnologyScope techScope = TechnologyScopeConfiguration.getInstance(project).getTechnologyScope();
        HashSet projectKeys = new HashSet();
        Collections.addAll(projectKeys, techScope.getTechnologyKeys());
        if (projectKeys.size() == 0) {
            return false;
        }
        RuleFunctionParameter keysParam = this.getRequiredParameterOrThrow(parameters, PARAM_TECHNOLOGY_KEY);
        String[] userKeys = keysParam.getValue().split(",");
        boolean matchAll = this.isMatchAll(parameters);
        if (matchAll) {
            for (String key : userKeys) {
                Assert.check((TechnologyRegistry.getInstance().getTechId(key) != null ? 1 : 0) != 0, (String)("WARNING: Technology key '" + key + "' in rule '" + String.valueOf(ruleContext.getAdditionalData("ruleId")) + "' has not been registered."));
                if (projectKeys.contains(key.trim())) continue;
                return false;
            }
            return true;
        }
        for (String key : userKeys) {
            if (!projectKeys.contains(key.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchAll(Map<String, RuleFunctionParameter> parameters) {
        RuleFunctionParameter param = parameters.get(PARAM_MATCH);
        if (param == null) {
            return true;
        }
        String match = param.getValue();
        Assert.printStackTrace((!MATCH_ALL.equals(match) && !MATCH_ANY.equals(match) ? 1 : 0) != 0, (String)"Parameter 'match', if specified, should be 'all' or 'any'");
        return MATCH_ALL.equals(match);
    }
}

