/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.javaxide.Util;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.NullArgumentException;

@ThreadSafe
public final class MetaClassList<T> {
    private final Class<T> instanceClass;
    private final List<MetaClass<T>> classes = new ArrayList<MetaClass<T>>();
    private final List<T> instances = new ArrayList<T>();

    public static <T> MetaClassList<T> get(Class<T> instanceClass) {
        if (instanceClass == null) {
            throw new NullArgumentException("null class");
        }
        return new MetaClassList<T>(instanceClass);
    }

    public static <T> MetaClassList<T> get(HashStructureHook hook, final String name, final String key, Class<T> instanceClass) {
        if (instanceClass == null) {
            throw new NullArgumentException("null class");
        }
        if (name == null) {
            throw new NullArgumentException("null name");
        }
        if (key == null) {
            throw new NullArgumentException("null key");
        }
        final MetaClassList<T> classList = new MetaClassList<T>(instanceClass);
        if (hook != null) {
            hook.addHashStructureHookListener(new HashStructureHookListener(){

                @Override
                public void elementVisited(HashStructureHookEvent e) {
                    this.process(e.getNewElementHashStructure());
                }

                @Override
                public void listenerAttached(HashStructureHookEvent e) {
                    this.process(e.getCombinedHashStructure());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void process(HashStructure hash) {
                    List list = hash.getAsList(name);
                    if (list != null) {
                        if (list instanceof ListStructure) {
                            Object object = ((ListStructure)list).iteratorLock();
                            synchronized (object) {
                                this.processList(list);
                            }
                        } else {
                            this.processList(list);
                        }
                    }
                }

                private void processList(List<HashStructure> list) {
                    for (HashStructure hash : list) {
                        MetaClass metaClass = LazyClassAdapter.getInstance(hash).getMetaClass(key);
                        if (metaClass == null) continue;
                        classList.add(metaClass);
                    }
                }
            });
        }
        return classList;
    }

    protected MetaClassList(Class<T> instanceClass) {
        this.instanceClass = instanceClass;
    }

    public synchronized void add(MetaClass<T> metaClass) {
        this.classes.add(metaClass);
    }

    public synchronized List<T> getInstances() {
        if (!this.classes.isEmpty()) {
            for (MetaClass<T> metaClass : this.classes) {
                T instance = Util.createInstance(metaClass, this.instanceClass);
                if (instance == null) continue;
                this.instances.add(instance);
            }
            this.classes.clear();
        }
        return Collections.unmodifiableList(new ArrayList<T>(this.instances));
    }
}

