/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.explorer.IconOverlayCoordinator;
import oracle.ide.feedback.FeedbackApi;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;

@FeedbackApi(value="IconOverlayTracker")
public abstract class IconOverlayTracker {
    private String _infoTypeId;
    private IconOverlayCache _overlayCache;
    private int _overlayBatchSize;
    private String _extensionId;
    private final Map<Element, Object> _validOverlayElements = new WeakHashMap<Element, Object>();
    private IconOverlayCoordinator _coordinator;
    private boolean _started;
    private static final IconOverlay[] EMPTY_OVERLAYS = new IconOverlay[0];

    public IconOverlayTracker() {
    }

    @Deprecated
    public IconOverlayTracker(String infoTypeId, IconOverlayCache cache) {
        this(infoTypeId, cache, 10);
    }

    @Deprecated
    public IconOverlayTracker(String infoTypeId, IconOverlayCache cache, int batchSize) {
        IconOverlayCoordinator coordinator = new IconOverlayCoordinator(infoTypeId, cache, batchSize, this);
        coordinator.attachToConsumers();
    }

    public IconOverlayCache getOverlayCache() {
        return this._overlayCache;
    }

    final void setOverlayCache(IconOverlayCache overlayCache) {
        this._overlayCache = overlayCache;
    }

    final void setCoordinator(IconOverlayCoordinator coordinator) {
        this._coordinator = coordinator;
    }

    final IconOverlayCoordinator getCoordinator() {
        return this._coordinator;
    }

    final void setInfoTypeId(String infoTypeId) {
        this._infoTypeId = infoTypeId;
    }

    final void setBatchSize(int batchSize) {
        this._overlayBatchSize = batchSize;
    }

    final int getBatchSize() {
        return this._overlayBatchSize;
    }

    final void setExtensionId(String extensionId) {
        this._extensionId = extensionId;
    }

    protected void configure() {
    }

    public final String getExtensionID() {
        return this._extensionId;
    }

    public final String getInfoTypeID() {
        return this._infoTypeId;
    }

    protected abstract boolean isControlled(Element var1);

    protected abstract IconOverlay[] getOverlays(Element[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element[] getValidElements() {
        LinkedHashSet<Element> validElements = new LinkedHashSet<Element>();
        validElements.addAll(Arrays.asList(this._overlayCache.getElementKeys(this._infoTypeId)));
        Map<Element, Object> map = this._validOverlayElements;
        synchronized (map) {
            validElements.addAll(this._validOverlayElements.keySet());
        }
        return validElements.toArray(new Element[validElements.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOverlay(Element e) {
        this.start();
        Map<Element, Object> map = this._validOverlayElements;
        synchronized (map) {
            this._validOverlayElements.remove(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOverlays() {
        this.start();
        Map<Element, Object> map = this._validOverlayElements;
        synchronized (map) {
            for (Element e : this.getValidElements()) {
                this._validOverlayElements.remove(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintOverlays() {
        HashSet<IconOverlayConsumer> c;
        this.start();
        Map<IconOverlayConsumer, IconOverlayCoordinator.NodeWatcher> map = this.getCoordinator().getNodeWatchers();
        synchronized (map) {
            c = new HashSet<IconOverlayConsumer>(this.getCoordinator().getNodeWatchers().keySet());
        }
        this.getCoordinator().repaintConsumerOverlays(c, 0L);
    }

    final void start() {
        if (this._started) {
            return;
        }
        this._started = true;
        ExitCommand.addShutdownHook(new ShutdownHook(){

            @Override
            public boolean canShutdown() {
                return true;
            }

            @Override
            public void shutdown() {
                IconOverlayTracker.this.stop();
            }
        });
        this.startTracking();
    }

    final void stop() {
        if (!this._started) {
            return;
        }
        this.stopTracking();
    }

    @Deprecated
    protected void startTracking() {
        this.startTrackingImpl();
    }

    @Deprecated
    public void stopTracking() {
        if (!this._started) {
            return;
        }
        this.getCoordinator().stop();
        this.stopTrackingImpl();
    }

    protected void startTrackingImpl() {
    }

    protected void stopTrackingImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void processPendingNodes() {
        Collection pendingNodeBatch;
        while ((pendingNodeBatch = this.getPendingNodeBatch()) != null) {
            IconOverlay[] controlledOverlays;
            final ArrayList nodes = new ArrayList(pendingNodeBatch);
            Map<Element, Object> map = this._validOverlayElements;
            synchronized (map) {
                for (Element e : nodes) {
                    this._validOverlayElements.put(e, null);
                }
            }
            BitSet controlled = new BitSet(nodes.size());
            ArrayList<Element> controlledNodes = new ArrayList<Element>();
            for (int i = 0; i < nodes.size(); ++i) {
                Element e = (Element)nodes.get(i);
                if (!this.isControlled(e)) continue;
                controlled.set(i);
                controlledNodes.add(e);
            }
            final ArrayList<IconOverlay> overlays = new ArrayList<IconOverlay>(nodes.size());
            IconOverlay[] iconOverlayArray = controlledOverlays = controlledNodes.isEmpty() ? null : this.getOverlays(controlledNodes.toArray(new Element[controlledNodes.size()]));
            if (controlledOverlays == null) {
                controlledOverlays = EMPTY_OVERLAYS;
            }
            if (controlledOverlays.length > 0 && controlledOverlays.length != controlledNodes.size() && FeedbackManager.isOn()) {
                StringBuilder message = new StringBuilder();
                message.append("IconOverlayTracker.getOverlays() implementation returned a different number of overlays than supplied nodes.");
                message.append('\n');
                message.append("Class: ");
                message.append(this.getClass().getName());
                FeedbackManager.reportAPIException("Misuse of IconOverlayTracker", (Throwable)new IllegalStateException(message.toString()), "IconOverlayTracker");
            }
            Iterator<IconOverlay> itr = Arrays.asList(controlledOverlays).iterator();
            for (int i = 0; i < nodes.size(); ++i) {
                if (controlled.get(i)) {
                    overlays.add(itr.hasNext() ? itr.next() : null);
                    continue;
                }
                overlays.add(null);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    IconOverlayCache cache = IconOverlayTracker.this.getOverlayCache();
                    if (cache == null) {
                        return;
                    }
                    Iterator itr = nodes.iterator();
                    Iterator itr2 = overlays.iterator();
                    while (itr.hasNext()) {
                        Element e = (Element)itr.next();
                        IconOverlay overlay = (IconOverlay)itr2.next();
                        if (e == null) continue;
                        if (overlay == null) {
                            cache.removeOverlay(IconOverlayTracker.this._infoTypeId, e);
                            continue;
                        }
                        cache.putOverlay(IconOverlayTracker.this._infoTypeId, e, overlay);
                    }
                    cache.fireOverlaysChanged();
                }
            });
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getPendingNodeBatch() {
        IconOverlayConsumer _consumer;
        while ((_consumer = this.findPendingConsumer()) != null) {
            Map<IconOverlayConsumer, LinkedList> map = this.getCoordinator().getPendingNodes();
            synchronized (map) {
                List queue = this.getCoordinator().getPendingNodes().get(_consumer);
                if (queue != null) {
                    int n = Math.min(queue.size(), this._overlayBatchSize);
                    ArrayList nodes = new ArrayList(n);
                    for (int i = 0; i < n; ++i) {
                        nodes.add(queue.remove(0));
                    }
                    return nodes;
                }
            }
            this.updateQueue(_consumer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IconOverlayConsumer findPendingConsumer() {
        Map<IconOverlayConsumer, LinkedList> map = this.getCoordinator().getPendingNodes();
        synchronized (map) {
            for (IconOverlayConsumer o : this.getCoordinator().getPendingNodes().keySet()) {
                Collection queue = this.getCoordinator().getPendingNodes().get(o);
                if (queue != null && queue.size() <= 0) continue;
                return o;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateQueue(IconOverlayConsumer consumer) {
        Collection visible;
        Map<IconOverlayConsumer, Object> map = this.getCoordinator().getNodeWatchers();
        synchronized (map) {
            if (!this.getCoordinator().getNodeWatchers().containsKey(consumer)) {
                return;
            }
            IconOverlayCoordinator.NodeWatcher watcher = this.getCoordinator().getNodeWatchers().get(consumer);
            visible = watcher.getVisibleNodes();
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        Iterator itr = visible.iterator();
        while (itr.hasNext()) {
            Element e = consumer.getElement(itr.next());
            if (e == null) continue;
            Map<Element, Object> map2 = this._validOverlayElements;
            synchronized (map2) {
                if (this._validOverlayElements.containsKey(e)) {
                    continue;
                }
            }
            queue.add(e);
        }
        map = this.getCoordinator().getPendingNodes();
        synchronized (map) {
            if (!this.getCoordinator().getPendingNodes().containsKey(consumer)) {
                return;
            }
            this.getCoordinator().getPendingNodes().put(consumer, queue);
        }
    }
}

