/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorBundle;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.natives.accessibility.HighContrast;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.layout.CenterLayout;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.RequestProcessor;

public abstract class AsynchronousEditor
extends Editor {
    private boolean m_Opened;
    private boolean m_Activated;
    private boolean m_Shown;
    private Context m_DelayedEditorContext;
    private Component m_EditorNotInitializedGUI;
    private final PreventAutoCloseNodeListener m_PreventAutoCloseNodeListener = new PreventAutoCloseNodeListener();
    private static final RequestProcessor m_RequestProcessor = new RequestProcessor("AsynchronousEditor", 25, true);
    private static final Color BG_COLOR = HighContrast.isHighContrastModeEnabled() ? SystemColor.window : Color.WHITE;
    private static final Color FG_COLOR = HighContrast.isHighContrastModeEnabled() ? SystemColor.windowText : Color.BLACK;

    public AsynchronousEditor() {
        if (this.asyncModeEnabled()) {
            this.setEditorAttribute("DELAY_PALETTE_LOAD", Boolean.TRUE);
        } else {
            this.setEditorAttribute("DELAY_PALETTE_LOAD", Boolean.FALSE);
        }
    }

    @Override
    public final void setContext(Context newContext) {
        this.m_PreventAutoCloseNodeListener.preventAutoClose(newContext);
        if (!this.asyncModeEnabled()) {
            super.setContext(newContext);
            this.updateContextImpl(newContext);
            return;
        }
        Context currentContext = this.getContext();
        if (this.m_DelayedEditorContext != null && newContext != null && this.m_DelayedEditorContext.getNode() == newContext.getNode()) {
            return;
        }
        if (ModelUtil.areEqual((Object)currentContext, (Object)newContext)) {
            this.updateContextImpl(newContext);
        } else if (newContext == null || newContext.getNode() == null) {
            this.updateContextImpl(newContext);
        } else {
            this.delayContextSet(newContext);
            if (Ide.isStarting()) {
                newContext.getNode().ensureOpen();
            }
        }
    }

    protected Context delayContextSet(Context newContext) {
        this.m_DelayedEditorContext = new Context(newContext);
        this.m_DelayedEditorContext.setView(this);
        super.setContext(newContext);
        return this.m_DelayedEditorContext;
    }

    protected boolean asyncModeEnabled() {
        return true;
    }

    @Override
    public final void open() {
        if (this.m_Opened) {
            return;
        }
        this.m_Opened = true;
        this.openImpl(this.isContentModelLoaded());
    }

    @Override
    public final void editorShown() {
        if (this.m_Shown) {
            return;
        }
        this.m_Shown = true;
        this.shownImpl(this.isContentModelLoaded());
    }

    @Override
    public final void activate() {
        super.activate();
        if (this.m_Activated) {
            return;
        }
        this.m_Activated = true;
        this.activateImpl(this.isContentModelLoaded());
    }

    @Override
    public final void deactivate() {
        if (this.m_Activated) {
            this.m_Activated = false;
            this.deactivateImpl(this.isContentModelLoaded());
        }
        super.deactivate();
    }

    @Override
    public final void editorHidden() {
        if (this.m_Shown) {
            this.m_Shown = false;
            this.hiddenImpl(this.isContentModelLoaded());
        }
    }

    @Override
    public final void close() {
        if (this.m_Opened) {
            this.m_Opened = false;
            this.m_PreventAutoCloseNodeListener.clear();
            this.closeImpl(this.isContentModelLoaded());
        }
        super.close();
    }

    protected abstract boolean isContentModelLoaded();

    @Override
    public final Component getGUI() {
        Component comp = this.getGUIComponent();
        if (comp == null) {
            comp = this.getEditorNotInitializedGUI();
        }
        return comp;
    }

    protected abstract Component getGUIComponent();

    protected final Component getEditorNotInitializedGUI() {
        if (this.m_EditorNotInitializedGUI == null) {
            JPanel panel = new JPanel((LayoutManager)new CenterLayout()){
                private boolean componentPainted;
                {
                    this.componentPainted = false;
                }

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    if (!this.componentPainted) {
                        this.componentPainted = true;
                        AsynchronousEditor.this.scheduleDelayedContext(AsynchronousEditor.this.m_DelayedEditorContext);
                    }
                }
            };
            panel.setBackground(BG_COLOR);
            panel.setForeground(FG_COLOR);
            panel.setOpaque(true);
            panel.add(this.createEditorNotInitializedGUI());
            this.m_EditorNotInitializedGUI = panel;
        }
        return this.m_EditorNotInitializedGUI;
    }

    private void scheduleDelayedContext(Context newContext) {
        if (newContext == null) {
            return;
        }
        Runnable contentGetter = this.createUIModelGetterTask(newContext);
        ProgressHandle handle = this.createProgressHandle(newContext, contentGetter);
        this.scheduleTask(contentGetter, handle, newContext);
    }

    protected Runnable createUIModelGetterTask(final Context newContext) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AsynchronousEditor.this.getEditorContent(newContext);
                }
                catch (Throwable throwable) {
                    AsynchronousEditor.invokeLaterAfterRepaint(new Runnable(){

                        @Override
                        public void run() {
                            AsynchronousEditor.this.setDelayedContext(newContext);
                            Component realEditorUI = AsynchronousEditor.this.getGUIComponent();
                            if (realEditorUI != null) {
                                AsynchronousEditor.this.switchEditorGUI(realEditorUI);
                                if (EditorManager.getEditorManager().getCurrentEditor() == AsynchronousEditor.this) {
                                    Ide.getMainWindow().requestViewsUpdate();
                                }
                            }
                        }
                    });
                    throw throwable;
                }
                AsynchronousEditor.invokeLaterAfterRepaint(new /* invalid duplicate definition of identical inner class */);
            }
        };
    }

    protected ProgressHandle createProgressHandle(Context newContext, Runnable contentGetter) {
        return ProgressHandle.createHandle((String)(EditorBundle.get("ASYNCH_EDITOR_LOADING_TEXT") + " " + newContext.getNode().getShortLabel()));
    }

    protected abstract void getEditorContent(Context var1);

    protected final void setDelayedContext(Context newContext) {
        if (this.m_DelayedEditorContext != null && this.m_DelayedEditorContext.getNode() == newContext.getNode()) {
            this.updateContextImpl(newContext);
        }
    }

    protected void updateContextImpl(Context context) {
        this.m_DelayedEditorContext = null;
        this.doSetContext(context);
        if (!this.asyncModeEnabled()) {
            return;
        }
        this.contextAvailable();
    }

    protected abstract void doSetContext(Context var1);

    protected void contextAvailable() {
        if (this.isOpened()) {
            this.openImpl(true);
        }
        if (this.isShown()) {
            this.shownImpl(true);
        }
        if (this.isActivated()) {
            this.activateImpl(true);
        }
        this.editorReady();
    }

    protected final boolean isOpened() {
        return this.m_Opened;
    }

    protected final boolean isActivated() {
        return this.m_Activated;
    }

    protected final boolean isShown() {
        return this.m_Shown;
    }

    protected void editorReady() {
        AsynchronousEditor.invokeLaterAfterRepaint(new Runnable(){

            @Override
            public void run() {
                AsynchronousEditor.this.setEditorAttribute("DELAY_PALETTE_LOAD", Boolean.FALSE);
            }
        });
    }

    protected final void switchEditorGuiInUiThread(final Component newEditorGUI) {
        SwingUtils.dispatch((Runnable)new Runnable(){

            @Override
            public void run() {
                AsynchronousEditor.this.switchEditorGUI(newEditorGUI);
            }
        });
    }

    protected void switchEditorGUI(Component newEditorGUI) {
        if (newEditorGUI != null) {
            Container editorContainer;
            Component oldEditorGUI = this.getGUI();
            if (oldEditorGUI == newEditorGUI) {
                oldEditorGUI = this.getEditorNotInitializedGUI();
            }
            if (oldEditorGUI != null && (editorContainer = oldEditorGUI.getParent()) != null && oldEditorGUI != newEditorGUI) {
                boolean transferFocus = this.isActivated();
                editorContainer.remove(oldEditorGUI);
                editorContainer.add(newEditorGUI);
                this.firePropertyChangeEvent("horizontal_unit_increment", null, null);
                this.firePropertyChangeEvent("vertical_unit_increment", null, null);
                this.firePropertyChangeEvent("horizontal_block_increment", null, null);
                this.firePropertyChangeEvent("vertical_unit_increment", null, null);
                if (transferFocus && this.getDefaultFocusComponent() != null) {
                    this.getDefaultFocusComponent().requestFocus();
                }
            }
            this.m_EditorNotInitializedGUI = null;
        }
    }

    protected void scheduleTask(final Runnable task, final ProgressHandle handle, Context context) {
        RequestProcessor progressTracker = this.getRequestProcessor();
        progressTracker.post(new Runnable(){

            @Override
            public void run() {
                handle.start();
                try {
                    task.run();
                }
                finally {
                    handle.finish();
                }
            }
        }, 0, 5);
    }

    protected RequestProcessor getRequestProcessor() {
        return m_RequestProcessor;
    }

    public static void invokeLaterAfterRepaint(final Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtils.invokeAfterRepaint((Runnable)runnable);
            }
        });
    }

    protected Component createEditorNotInitializedGUI() {
        JLabel label = new JLabel(this.getEditorNotInitializedMessage());
        Icon throbber = OracleIcons.getIcon((String)"throbber.gif");
        label.setIcon(throbber);
        label.setIconTextGap(6);
        label.setHorizontalTextPosition(10);
        return label;
    }

    protected String getEditorNotInitializedMessage() {
        return EditorBundle.get("EDITOR_NOT_INITIALIZED");
    }

    @Override
    public void update(Object observed, UpdateMessage change) {
    }

    protected abstract void openImpl(boolean var1);

    protected void closeImpl(boolean contentAvailable) {
    }

    protected void shownImpl(boolean contentAvailable) {
        super.editorShown();
    }

    protected void hiddenImpl(boolean contentAvailable) {
    }

    protected void activateImpl(boolean contentAvailable) {
        Component focusComponent = this.getDefaultFocusComponent();
        if (focusComponent != null) {
            focusComponent.requestFocus();
        }
    }

    protected void deactivateImpl(boolean contentAvailable) {
    }

    private class PreventAutoCloseNodeListener
    extends NodeListener {
        private TextNode m_AttachedToNode = null;
        private TextBuffer m_PinnedTextBuffer = null;

        private PreventAutoCloseNodeListener() {
        }

        public void preventAutoClose(Context ideContext) {
            Node node;
            TextNode textNode = null;
            if (ideContext != null && (node = ideContext.getNode()) instanceof TextNode) {
                textNode = (TextNode)node;
            }
            if (textNode != this.m_AttachedToNode) {
                if (this.m_AttachedToNode != null) {
                    this.m_AttachedToNode.removeNodeListener(this);
                    this.m_AttachedToNode = null;
                    this.m_PinnedTextBuffer = null;
                }
                if (textNode != null) {
                    this.m_AttachedToNode = textNode;
                    this.m_AttachedToNode.addNodeListener(this);
                    if (this.m_AttachedToNode.isOpen()) {
                        this.m_PinnedTextBuffer = this.m_AttachedToNode.acquireTextBuffer();
                    }
                }
            }
        }

        public void clear() {
            this.m_PinnedTextBuffer = null;
            if (this.m_AttachedToNode != null) {
                this.m_AttachedToNode.removeNodeListener(this);
                this.m_AttachedToNode = null;
            }
        }

        @Override
        public void nodeOpened(NodeEvent e) {
            if (e.getNode() == this.m_AttachedToNode) {
                this.m_PinnedTextBuffer = this.m_AttachedToNode.acquireTextBuffer();
            }
        }

        @Override
        public void nodeWillClose(NodeEvent e) {
            if (e.getNode() == this.m_AttachedToNode) {
                this.clear();
            }
        }
    }
}

