/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.util.Iterator;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.layout.LayoutsImpl;

public final class DrawerLayoutUtil {
    private static final String VIEW_DATA_PROPERTY = "view-data";
    private static final String GLOBAL_PROPERTY = "global";
    private static final String DRAWER_MODEL_PROPERTY = "DrawerModel.Entry";
    private static final String UNIQUE_NAME_PROPERTY = "UniqueName";
    private static final String PANEL_LAYOUT_PROPERTY = "PanelLayout";
    private static final String DRAWER_PROPERTY = "Drawer";
    private static final String DRAWER_EXPANDED = "Expanded";

    private DrawerLayoutUtil() {
    }

    public static boolean isDrawerExpanded(String id) {
        DrawerViewData drawerViewData = DrawerLayoutUtil.searchDrawerData(id);
        if (drawerViewData == null) {
            return false;
        }
        return DrawerLayoutUtil.checkPanelLayouts(drawerViewData);
    }

    static StructuredPropertyAccess getDrawerData(String id) {
        DrawerViewData drawerViewData = DrawerLayoutUtil.searchDrawerData(id);
        return drawerViewData == null ? null : drawerViewData.getDrawerData();
    }

    static StructuredPropertyAccess getGlobal() {
        LayoutsImpl layout = LayoutsImpl.getInstance();
        StructuredPropertyAccess clientLayout = layout.getClientLayoutData();
        if (clientLayout == null) {
            return null;
        }
        return clientLayout.getChildNode(GLOBAL_PROPERTY);
    }

    private static DrawerViewData searchDrawerData(String id) {
        StructuredPropertyAccess global = DrawerLayoutUtil.getGlobal();
        if (global == null) {
            return null;
        }
        Iterator viewData = global.getChildNodes(VIEW_DATA_PROPERTY);
        while (viewData.hasNext()) {
            StructuredPropertyAccess data = (StructuredPropertyAccess)viewData.next();
            DrawerViewData drawerViewData = DrawerLayoutUtil.getDrawerViewData(id, data);
            if (drawerViewData == null) continue;
            return drawerViewData;
        }
        return null;
    }

    private static DrawerViewData getDrawerViewData(String id, StructuredPropertyAccess viewData) {
        Iterator drawerModelEntries = viewData.getChildNodes(DRAWER_MODEL_PROPERTY);
        int index = 0;
        while (drawerModelEntries.hasNext()) {
            StructuredPropertyAccess drawerModelEntry = (StructuredPropertyAccess)drawerModelEntries.next();
            String drawerUniqueName = drawerModelEntry.getProperty(UNIQUE_NAME_PROPERTY, "");
            if (drawerUniqueName.equals(id) || drawerUniqueName.contains(id + ".")) {
                return new DrawerViewData(drawerModelEntry, viewData, index);
            }
            ++index;
        }
        return null;
    }

    private static boolean checkPanelLayouts(DrawerViewData drawerViewData) {
        StructuredPropertyAccess panelLayout = drawerViewData.getViewData().getChildNode(PANEL_LAYOUT_PROPERTY);
        if (panelLayout == null) {
            return false;
        }
        Iterator drawers = panelLayout.getChildNodes(DRAWER_PROPERTY);
        int panelIndex = 0;
        while (drawers.hasNext()) {
            StructuredPropertyAccess drawer = (StructuredPropertyAccess)drawers.next();
            String expanded = drawer.getProperty(DRAWER_EXPANDED, "");
            if (expanded != null && expanded.equals("true") && panelIndex == drawerViewData.getIndex()) {
                return true;
            }
            ++panelIndex;
        }
        return false;
    }

    private static class DrawerViewData {
        private StructuredPropertyAccess viewData;
        private StructuredPropertyAccess drawerData;
        private int index;

        DrawerViewData(StructuredPropertyAccess drawerData, StructuredPropertyAccess dataView, int index) {
            this.drawerData = drawerData;
            this.index = index;
            this.viewData = dataView;
        }

        StructuredPropertyAccess getDrawerData() {
            return this.drawerData;
        }

        int getIndex() {
            return this.index;
        }

        StructuredPropertyAccess getViewData() {
            return this.viewData;
        }
    }
}

