/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.resource.DialogsArb;
import oracle.javatools.ui.layout.VerticalFlowLayout;

public class OptionSelectionDialog
extends JPanel {
    private JScrollPane _optionListScrollWindow = new JScrollPane();
    private JPanel _optionsPanel = new JPanel();
    private VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private ButtonGroup _radioGroup;

    public OptionSelectionDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean showDialog(Component parent, String title, String optionsLabel, Object[] optionItems, String helpTopic) {
        this.setHelpTopic(helpTopic);
        this.initOptions(optionsLabel, optionItems);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog(parent, this, this._optionsPanel, title, 7);
        dlg.setDefaultButton(1);
        return WizardLauncher.runDialog((JDialog)dlg);
    }

    public Object getSelectedOption() {
        if (this._radioGroup != null) {
            OptionModel bm = (OptionModel)this._radioGroup.getSelection();
            return bm.getOption();
        }
        return null;
    }

    private void initOptions(String label, Object[] options) {
        TitledBorder border = (TitledBorder)this._optionListScrollWindow.getBorder();
        border.setTitle(label);
        this._optionsPanel.removeAll();
        this._radioGroup = new ButtonGroup();
        for (int i = 0; i < options.length; ++i) {
            JRadioButton rb = new JRadioButton(options[i].toString());
            OptionModel model = new OptionModel(options[i]);
            model.setSelected(i == 0);
            rb.setModel(model);
            this._radioGroup.add(rb);
            this._optionsPanel.add((Component)rb, null);
        }
    }

    private void setHelpTopic(String helpTopic) {
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(338, 188));
        this._optionListScrollWindow.setBorder(BorderFactory.createTitledBorder(DialogsArb.getString(35)));
        this._optionsPanel.setLayout((LayoutManager)this.verticalFlowLayout1);
        this._optionListScrollWindow.getViewport().add((Component)this._optionsPanel, null);
        this.add((Component)this._optionListScrollWindow, "Center");
    }

    private static class OptionModel
    extends JToggleButton.ToggleButtonModel {
        private Object _option;

        public OptionModel(Object option) {
            this._option = option;
        }

        public Object getOption() {
            return this._option;
        }
    }
}

