/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.elementtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import oracle.ide.controls.elementtree.ElementRegistry;
import oracle.ide.controls.elementtree.Filter;
import oracle.ide.controls.elementtree.HierarchyChangeEvent;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class ElementTreeNode
implements TreeNode {
    private final Element _element;
    private final Listeners _listeners = new Listeners();
    private ElementTreeNode _parent;
    private ArrayList<ElementTreeNode> _cachedChildren;
    private int _filterChangeNumber;

    ElementTreeNode(Element element) {
        this._element = element;
    }

    List<ElementTreeNode> getChildren() {
        ArrayList<ElementTreeNode> ret;
        ElementRegistry filterRegistry = this.getElementRegistry();
        int filterChangeNumber = filterRegistry.getFilterChangeNumber();
        boolean useCachedValue = false;
        if (filterChangeNumber == this._filterChangeNumber && this._cachedChildren != null) {
            useCachedValue = true;
        }
        if (useCachedValue) {
            ret = this._cachedChildren;
        } else {
            boolean canCacheChildren = false;
            if (this._element instanceof Subject) {
                canCacheChildren = true;
            }
            ret = new ArrayList();
            List<Filter> filters = filterRegistry.getFilters(this._element);
            switch (filters.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Filter filter = filters.get(0);
                    List<Element> children = filter.getChildren(this._element);
                    if (children == null) break;
                    for (Element childElement : children) {
                        if (!filter.isValid(childElement)) continue;
                        ElementTreeNode childNode = new ElementTreeNode(childElement);
                        childNode.attach(this);
                        ret.add(childNode);
                    }
                    break;
                }
                default: {
                    HashSet<Element> knownChildren = new HashSet<Element>();
                    for (Filter filter : filters) {
                        try {
                            List<Element> children = filter.getChildren(this._element);
                            if (children == null) continue;
                            for (Element childElement : children) {
                                if (knownChildren.contains(childElement)) continue;
                                boolean isValid = true;
                                for (int j = 0; j < filters.size() && isValid; ++j) {
                                    Filter validatingFilter = filters.get(j);
                                    if (validatingFilter.isValid(childElement)) continue;
                                    isValid = false;
                                }
                                if (!isValid) continue;
                                knownChildren.add(childElement);
                                ElementTreeNode childNode = new ElementTreeNode(childElement);
                                childNode.attach(this);
                                ret.add(childNode);
                            }
                        }
                        catch (Exception e) {
                            FeedbackManager.reportException(e);
                        }
                    }
                }
            }
            if (canCacheChildren) {
                this._cachedChildren = ret;
                this._filterChangeNumber = filterRegistry.getFilterChangeNumber();
            }
        }
        return ret;
    }

    public Enumeration children() {
        List<ElementTreeNode> children = this.getChildren();
        Enumeration<ElementTreeNode> enumeration = Collections.enumeration(children);
        return enumeration;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        List<ElementTreeNode> children = this.getChildren();
        ElementTreeNode child = children.get(childIndex);
        return child;
    }

    @Override
    public int getChildCount() {
        List<ElementTreeNode> children = this.getChildren();
        int ret = children.size();
        return ret;
    }

    @Override
    public ElementTreeNode getParent() {
        return this._parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        List<ElementTreeNode> children = this.getChildren();
        int index = children.indexOf(node);
        return index;
    }

    @Override
    public boolean getAllowsChildren() {
        boolean ret = this._element.mayHaveChildren();
        return ret;
    }

    @Override
    public boolean isLeaf() {
        return !this._element.mayHaveChildren();
    }

    protected void attach(ElementTreeNode parent) {
        this._parent = parent;
        this.attachObserver();
    }

    void attachObserver() {
        if (this._element instanceof Subject) {
            Subject subject = (Subject)((Object)this._element);
            subject.attach(this._listeners);
        }
    }

    protected void detach() {
        this.detachObserver();
        if (this._cachedChildren != null) {
            for (ElementTreeNode child : this._cachedChildren) {
                child.detach();
            }
        }
        this._parent = null;
    }

    void detachObserver() {
        if (this._element instanceof Subject) {
            Subject subject = (Subject)((Object)this._element);
            subject.detach(this._listeners);
        }
    }

    void clearCache() {
        if (this._cachedChildren != null) {
            for (ElementTreeNode elementTreeNode : this._cachedChildren) {
                elementTreeNode.detach();
            }
            this._cachedChildren = null;
        }
    }

    public String toString() {
        return this._element.getShortLabel();
    }

    protected void fireHierarchyChanged(HierarchyChangeEvent event) {
        if (this._parent != null) {
            this._parent.fireHierarchyChanged(event);
        }
    }

    public Element getElement() {
        return this._element;
    }

    public ElementRegistry getElementRegistry() {
        if (this._parent == null) {
            return null;
        }
        return this._parent.getElementRegistry();
    }

    private class Listeners
    implements Observer {
        private Listeners() {
        }

        @Override
        public void update(Object observed, UpdateMessage change) {
            HierarchyChangeEvent event;
            int messageID = change.getMessageID();
            if (messageID == UpdateMessage.STRUCTURE_CHANGED) {
                event = new HierarchyChangeEvent(ElementTreeNode.this, 1, null);
            } else if (messageID == UpdateMessage.CHILD_ADDED) {
                List addedObjects = change.getAddObjects();
                event = new HierarchyChangeEvent(ElementTreeNode.this, 2, addedObjects);
            } else if (messageID == UpdateMessage.CHILD_REMOVED) {
                List removedObjects = change.getRemoveObjects();
                event = new HierarchyChangeEvent(ElementTreeNode.this, 1, removedObjects);
            } else {
                event = null;
            }
            if (event != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    ElementTreeNode.this.fireHierarchyChanged(event);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ElementTreeNode.this.fireHierarchyChanged(event);
                        }
                    });
                }
            }
        }
    }
}

