/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.elementtree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.controls.elementtree.ElementTreeNode;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;

final class ElementCellRenderer
extends DefaultTreeCellRenderer {
    public static final TreeCellRenderer INSTANCE = new ElementCellRenderer();
    private final Color _inactiveBackgroundSelectionColor;
    private final Color _inactiveTextSelectionColor;
    private final HashMap<Integer, Font> _fontCache = new HashMap(4);
    private ElementTreeNode _currentNode;
    private JTree _currentTree;

    public ElementCellRenderer() {
        this._inactiveBackgroundSelectionColor = ElementCellRenderer.getUIColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground", this.backgroundSelectionColor);
        this._inactiveTextSelectionColor = ElementCellRenderer.getUIColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground", this.textSelectionColor);
    }

    private static Color getUIColor(Object key, Color defaultColor) {
        Color color = UIManager.getColor(key);
        if (color != null) {
            return color;
        }
        return defaultColor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this._currentNode = (ElementTreeNode)value;
        this._currentTree = tree;
        Element element = this._currentNode.getElement();
        String text = element.getShortLabel();
        Icon icon = element.getIcon();
        this.getFont(tree, this._currentNode);
        Component ret = super.getTreeCellRendererComponent(tree, text, sel, expanded, leaf, row, hasFocus);
        this.setIcon(icon);
        return ret;
    }

    @Override
    public Color getBackgroundSelectionColor() {
        boolean isFocused = this._currentTree.hasFocus();
        return isFocused ? super.getBackgroundSelectionColor() : this._inactiveBackgroundSelectionColor;
    }

    @Override
    public Color getTextSelectionColor() {
        boolean isFocused = this._currentTree.hasFocus();
        return isFocused ? super.getTextSelectionColor() : this._inactiveTextSelectionColor;
    }

    @Override
    public String getToolTipText() {
        String ret = null;
        if (this._currentNode != null) {
            Element element = this._currentNode.getElement();
            ret = element.getToolTipText();
        }
        return ret;
    }

    private Font getFont(JTree tree, ElementTreeNode node) {
        int style = this.getFontStyle(node);
        Font font = this._fontCache.get(style);
        if (font == null) {
            Font baseFont = UIManager.getFont("Oracle.dirtyFont");
            if (baseFont == null) {
                baseFont = tree.getFont();
            }
            font = baseFont.deriveFont(style);
            this._fontCache.put(style, font);
        }
        return font;
    }

    private int getFontStyle(ElementTreeNode node) {
        int ret = 0;
        Element element = node.getElement();
        if (this.isDirty(element)) {
            ret |= 2;
        }
        if (this.isActive(element)) {
            ret |= 1;
        }
        return ret;
    }

    private boolean isActive(Element element) {
        Attributes attributes = element.getAttributes();
        boolean ret = attributes.isSet(ElementAttributes.ACTIVE);
        return ret;
    }

    private boolean isDirty(Element element) {
        Attributes attributes = element.getAttributes();
        boolean ret = attributes.isSet(ElementAttributes.COMPOSITE) ? attributes.isSet(ElementAttributes.DIRTY_COMPOSITE) : attributes.isSet(ElementAttributes.DIRTY);
        return ret;
    }
}

