/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.ExtensionNavigable;
import oracle.ide.config.ExtensionSettingsPage;
import oracle.ide.config.ExtensionSettingsUI;
import oracle.ide.config.SettingsCustomizations;
import oracle.ide.config.SettingsPageCustomizationHelper;
import oracle.ide.config.SettingsUICustomizationsHook;
import oracle.ide.config.SettingsUIHook;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;

public final class SettingsUIRegistry {
    private SettingsUIRegistry() {
    }

    public static SettingsPageCustomizationHelper getHelper(Traversable t, String pageId) {
        return new SettingsPageCustomizationHelper(t, pageId);
    }

    public static final SettingsCustomizations getCustomizations() {
        SettingsUICustomizationsHook hook = (SettingsUICustomizationsHook)ExtensionRegistry.getExtensionRegistry().getHook(SettingsUICustomizationsHook.ELEMENT);
        if (hook != null) {
            return hook.getSettingsCustomizations();
        }
        return null;
    }

    public static final Collection<Navigable> getExtensionNavigables(String dialogId) {
        if (dialogId == null) {
            throw new NullPointerException("dialogId is null");
        }
        Collection<String> hiddenPages = SettingsUIRegistry.getCustomizations().getHiddenPages();
        ArrayList<ExtensionNavigable> navigables = new ArrayList<ExtensionNavigable>();
        SettingsUIHook hook = (SettingsUIHook)ExtensionRegistry.getExtensionRegistry().getHook(SettingsUIHook.ELEMENT);
        if (hook != null) {
            ExtensionSettingsUI ui = hook.getExtensionSettingsUI();
            Collection<ExtensionSettingsPage> pages = ui.getChildren(dialogId);
            for (ExtensionSettingsPage page : pages) {
                if (hiddenPages.contains(page.getIdPath())) continue;
                navigables.add(new ExtensionNavigable(page));
            }
        }
        return Collections.unmodifiableCollection(navigables);
    }

    public static final String getObjectLabel(String dialogId) {
        SettingsUIHook hook = (SettingsUIHook)ExtensionRegistry.getExtensionRegistry().getHook(SettingsUIHook.ELEMENT);
        if (hook != null) {
            return hook.getExtensionSettingsUI().getObjectLabel(dialogId);
        }
        return "";
    }
}

