/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DTCache
implements Copyable {
    static final String FILENAME = "dtcache.xml";
    static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"dt-cache");
    static final String ROOT_TAG = "dt-cache";
    private Document document;
    private Map<String, Object> map = new TreeMap<String, Object>();
    private Object2Dom o2d;
    private Element rootNode;
    private String encoding;
    private static final String KEY_TAG = "Key";
    private static final String VALUE_TAG = "Value";
    private static final String ITEM_TAG = "Item";
    private static final String CLASS_ATTR = "class";

    public Object getData(String dataKey) {
        return this.getValue(dataKey, null);
    }

    public Object getData(String dataKey, ClassLoader classLoader) {
        return this.getValue(dataKey, classLoader);
    }

    public String getString(String dataKey) {
        Object obj = this.getValue(dataKey, null);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public int getInteger(String dataKey, int defaultVal) {
        Object obj = this.getValue(dataKey, null);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return defaultVal;
    }

    public boolean getBoolean(String dataKey, boolean defaultVal) {
        Object object = this.getValue(dataKey, null);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return defaultVal;
    }

    public URL getURL(String dataKey) {
        Object data = this.getValue(dataKey, null);
        if (data instanceof URL) {
            return (URL)data;
        }
        return null;
    }

    public void putData(String dataKey, Copyable data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.putValue(dataKey, data);
    }

    public void putData(String dataKey, List copyableList) {
        if (copyableList == null) {
            throw new IllegalArgumentException();
        }
        this.putValue(dataKey, copyableList);
    }

    public void putData(String dataKey, Map copyableMap) {
        if (copyableMap == null) {
            throw new IllegalArgumentException();
        }
        this.putValue(dataKey, copyableMap);
    }

    public void putString(String dataKey, String string) {
        this.putValue(dataKey, string);
    }

    public void putBoolean(String dataKey, boolean b) {
        this.putBoolean(dataKey, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public void putBoolean(String dataKey, Boolean b) {
        this.putValue(dataKey, b);
    }

    public void putURL(String dataKey, URL url) {
        this.putValue(dataKey, url);
    }

    public void putInteger(String dataKey, int i) {
        this.putInteger(dataKey, (Integer)i);
    }

    public void putInteger(String dataKey, Integer i) {
        this.putValue(dataKey, i);
    }

    public Object remove(String dataKey) {
        return this.map.remove(dataKey);
    }

    public void removeAll() {
        this.map.clear();
    }

    public boolean save() {
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".save");
        boolean bRet = false;
        try {
            URL url = DTCache.getConfigURL();
            this.saveData(url);
            bRet = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PerformanceLogger.get().stopTiming(this.getClass().getName() + ".save", "DTCache.save()");
        return bRet;
    }

    public boolean load() {
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".load");
        boolean bRet = false;
        try {
            URL url = DTCache.getConfigURL();
            this.parse();
            this.o2d = Object2Dom.newInstance();
            this.o2d.setDocumentURL(url);
            bRet = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PerformanceLogger.get().stopTiming(this.getClass().getName() + ".load", "DTCache.load()");
        return bRet;
    }

    public Object copyTo(Object target) {
        DTCache copy = target != null ? (DTCache)target : new DTCache();
        ModelUtil.deepCopy(this.map, copy.map);
        return copy;
    }

    public String toString() {
        return URLFileSystem.getPlatformPathName((URL)DTCache.getConfigURL());
    }

    private static URL getConfigURL() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        return URLFactory.newURL((URL)er.getSystemDirectory("oracle.ide"), (String)FILENAME);
    }

    private void parse() {
        block4: {
            URL url = DTCache.getConfigURL();
            InputStream inputStream = null;
            DOMParser domParser = new DOMParser();
            try {
                domParser.setPreserveWhitespace(false);
                inputStream = url.openStream();
                domParser.parse(inputStream);
                XMLDocument xmlDocument = domParser.getDocument();
                this.document = xmlDocument;
                this.parseKeysIntoMap();
                inputStream.close();
            }
            catch (Exception e) {
                if (inputStream == null) break block4;
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    private void parseKeysIntoMap() {
        NodeList nodelist = this.document.getElementsByTagNameNS("*", ROOT_TAG);
        this.rootNode = (Element)nodelist.item(0);
        nodelist = this.rootNode.getChildNodes();
        int numChildren = nodelist.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node n = nodelist.item(i);
            NodeList keyvalueNodes = n.getChildNodes();
            String key = null;
            Element valueNode = null;
            for (int j = 0; j < keyvalueNodes.getLength(); ++j) {
                Node jn;
                String localName;
                if (j == 0) {
                    key = null;
                    valueNode = null;
                }
                if ((localName = (jn = keyvalueNodes.item(j)).getLocalName()) != null) {
                    if (localName.equals(KEY_TAG)) {
                        key = jn.getTextContent();
                    } else if (localName.equals(VALUE_TAG)) {
                        valueNode = (Element)jn;
                    }
                }
                if (key != null && valueNode != null) break;
            }
            if (key == null || valueNode == null) continue;
            this.map.put(key, valueNode);
        }
    }

    private Object getValue(String key, ClassLoader classLoader) {
        Object obj = this.map.get(key);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Element)) {
            return obj;
        }
        Object resolvedObject = this.getValueForBasicElement((Element)obj);
        if (resolvedObject != null) {
            return resolvedObject;
        }
        try {
            String attr = DTCache.getClassAttribute((Element)obj);
            if (attr == null || attr.length() == 0) {
                attr = "java.lang.String";
            }
            Class c = this.lookupClass(attr);
            ClassLoader objectClassLoader = classLoader;
            if (objectClassLoader == null) {
                if (attr.startsWith("java")) {
                    StackTraceElement[] ste = Thread.currentThread().getStackTrace();
                    int position = -1;
                    for (int i = 1; i < ste.length && position == -1; ++i) {
                        String classname = ste[i].getClassName();
                        if (classname.equals("oracle.ide.config.DTCache")) continue;
                        position = i;
                    }
                    Class c2 = this.lookupClass(ste[position].getClassName());
                    objectClassLoader = c2 == null ? c.getClassLoader() : c2.getClassLoader();
                } else {
                    objectClassLoader = c.getClassLoader();
                }
            }
            resolvedObject = this.o2d.toObject((Element)obj, c, true, objectClassLoader, true);
            this.map.put(key, resolvedObject);
            return resolvedObject;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Object getValueForBasicElement(Element element) {
        String attr = DTCache.getClassAttribute(element);
        if (attr == null || attr.length() == 0) {
            return element.getTextContent();
        }
        if (attr.equals("java.lang.String")) {
            return element.getTextContent();
        }
        if (attr.equals("java.lang.Boolean")) {
            String value = element.getTextContent();
            return Boolean.valueOf(value);
        }
        if (attr.equals("java.lang.Integer")) {
            String value = element.getTextContent();
            return Integer.valueOf(value);
        }
        return null;
    }

    private void putValue(String dataKey, Object value) {
        if (!this.putValueForBasicElement(dataKey, value)) {
            this.map.put(dataKey, value);
        }
    }

    private boolean putValueForBasicElement(String dataKey, Object value) {
        if (value == null) {
            this.map.put(dataKey, null);
            return true;
        }
        String attr = value.getClass().getName();
        boolean basicClass = false;
        if (attr.equals("java.lang.String") || attr.equals("java.lang.Boolean") || attr.equals("java.lang.Integer")) {
            basicClass = true;
        }
        if (!basicClass) {
            return false;
        }
        Object obj = this.map.get(dataKey);
        if (obj == null) {
            this.createBasicElement(dataKey, value);
        } else {
            Element valueElement = (Element)obj;
            valueElement.setTextContent(value.toString());
        }
        return true;
    }

    private void createBasicElement(String dataKey, Object value) {
        if (this.document == null) {
            this.createDocument();
        }
        Element newElement = this.document.createElementNS(NAMESPACE_URI, VALUE_TAG);
        DTCache.setClassAttribute(newElement, value.getClass().getName());
        String s = value.toString();
        newElement.setTextContent(s);
        this.map.put(dataKey, newElement);
    }

    private XMLDocument createDocument() {
        XMLDocument xmlDocument = new XMLDocument();
        this.document = xmlDocument;
        xmlDocument.setVersion("1.0");
        xmlDocument.setEncoding(this.getEncoding());
        this.rootNode = this.document.createElementNS(NAMESPACE_URI, ROOT_TAG);
        DTCache.setClassAttribute(this.rootNode, "java.util.HashMap");
        this.document.appendChild(this.rootNode);
        return xmlDocument;
    }

    private void saveData(URL url) {
        XMLDocument xmlDocument = this.createDocument();
        Object2Dom o2d = Object2Dom.newInstance();
        o2d.setDocumentURL(DTCache.getConfigURL());
        Set<Map.Entry<String, Object>> mapSet = this.map.entrySet();
        for (Map.Entry<String, Object> entry : mapSet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.createItemElement(key, value, xmlDocument, o2d);
        }
        try {
            XMLUtil.writeXML((XMLDocument)xmlDocument, (URL)url);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    private void createItemElement(String key, Object value, XMLDocument document, Object2Dom o2d) {
        Element itemElement = document.createElementNS(NAMESPACE_URI, ITEM_TAG);
        Element keyElement = document.createElementNS(NAMESPACE_URI, KEY_TAG);
        keyElement.setTextContent(key);
        itemElement.appendChild(keyElement);
        if (value instanceof Element) {
            try {
                document.adoptNode((Node)((Element)value));
            }
            catch (Exception domEx) {
                try {
                    document.importNode((Node)((Element)value), true);
                }
                catch (Exception impEx) {
                    impEx.printStackTrace();
                }
            }
            itemElement.appendChild((Element)value);
        } else {
            Element valueelement = null;
            if (value == null) {
                valueelement = document.createElementNS(NAMESPACE_URI, VALUE_TAG);
                DTCache.setClassAttribute(valueelement, "java.lang.String");
                valueelement.setTextContent("");
            } else {
                valueelement = o2d.toElement(document, value, VALUE_TAG, value.getClass(), NAMESPACE_URI);
                DTCache.setClassAttribute(valueelement, value.getClass().getName());
            }
            itemElement.appendChild(valueelement);
        }
        this.rootNode.appendChild(itemElement);
    }

    private String getEncoding() {
        return this.encoding != null ? this.encoding : "UTF-8";
    }

    private Class lookupClass(String className) {
        Class<?> returnClass = null;
        try {
            if (className.startsWith("java.")) {
                returnClass = Class.forName(className);
            } else {
                Collection allExtensions = ExtensionRegistry.getExtensionRegistry().getExtensions();
                for (Extension extension : allExtensions) {
                    if (!ExtensionRegistry.getExtensionRegistry().isFullyLoaded(extension)) continue;
                    ClassLoader cl = ExtensionRegistry.getExtensionRegistry().getClassLoader(extension.getID());
                    try {
                        Class<?> c = Class.forName(className, false, cl);
                        if (c == null) continue;
                        return c;
                    }
                    catch (ClassNotFoundException cnfe) {
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnClass;
    }

    private static String getClassAttribute(Element element) {
        return DTCache.getAttribute(element, CLASS_ATTR);
    }

    private static void setClassAttribute(Element element, String value) {
        DTCache.setAttribute(element, CLASS_ATTR, value);
    }

    private static String getAttribute(Element element, String name) {
        String attr = element.getAttributeNS(null, name);
        if (attr == null || attr.isEmpty()) {
            attr = element.getAttributeNS(NAMESPACE_URI, name);
        }
        return attr;
    }

    private static void setAttribute(Element element, String name, String value) {
        element.setAttributeNS(null, name, value);
    }
}

