/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.ide.extension.Extension;
import javax.swing.SwingUtilities;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.cmd.FilesToSaveModelBuilder;
import oracle.ide.cmd.FilesToSaveOnCloseCollector;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.util.Executors;
import oracle.javatools.util.WeightedList;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

@ThreadSafe
public class ExitCommand
extends Command {
    public static final String EXIT_STATUS = "ExitCommand.EXIT_STATUS";
    public static final String SKIP_SAVE_ALL = "ExitCommand.SKIP_SAVE_ALL";
    public static final String SILENT_SAVE_ALL = "ExitCommand.SILENT_SAVE_ALL";
    private static final WeightedList<ShutdownHook> _shutdownHooks = new WeightedList();
    private static final ConcurrentMap<ExecutorService, ExecutorServiceRecord> _executors = new ConcurrentHashMap<ExecutorService, ExecutorServiceRecord>();
    private static Runnable _terminateHook = null;

    public ExitCommand() {
        super(4);
    }

    public static void registerTerminateHook(Runnable terminateHandlingHook) {
        if (_terminateHook != null) {
            throw new IllegalStateException("only one terminate hook should ever be registered");
        }
        _terminateHook = terminateHandlingHook;
    }

    public static void runTerminateHook() {
        if (_terminateHook != null) {
            _terminateHook.run();
        }
    }

    public static void addShutdownHook(ShutdownHook hook) {
        ExitCommand.addShutdownHook(hook, 0.5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShutdownHook(ShutdownHook hook, double weight) {
        WeightedList<ShutdownHook> weightedList = _shutdownHooks;
        synchronized (weightedList) {
            _shutdownHooks.add((Object)hook, weight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeShutdownHook(ShutdownHook hook) {
        WeightedList<ShutdownHook> weightedList = _shutdownHooks;
        synchronized (weightedList) {
            _shutdownHooks.remove((Object)hook);
        }
    }

    public static void addExecutorService(ExecutorService executor, String name) {
        ExitCommand.addExecutorService(executor, name, true);
    }

    public static void addExecutorService(ExecutorService executor, String name, boolean immediate) {
        if (executor == null) {
            throw new NullPointerException("null executor");
        }
        if (name == null) {
            throw new NullPointerException("null name");
        }
        _executors.put(executor, new ExecutorServiceRecord(executor, name, immediate));
    }

    public static void removeExecutorService(ExecutorService executor) {
        _executors.remove(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean canShutdown() {
        WeightedList<ShutdownHook> weightedList = _shutdownHooks;
        // MONITORENTER : weightedList
        boolean isEmpty = _shutdownHooks.isEmpty();
        // MONITOREXIT : weightedList
        if (isEmpty) {
            return true;
        }
        try {
            Assert.startTiming((String)(this.getClass().getName() + ".canShutdown"), (String)"Querying ShutdownHooks", (boolean)false);
            weightedList = _shutdownHooks;
            // MONITORENTER : weightedList
            for (ShutdownHook hook : _shutdownHooks) {
                try {
                    Assert.startTiming((String)(this.getClass().getName() + ".canShutdown." + hook.getClass().getName()), null, (boolean)false);
                    if (hook.canShutdown()) continue;
                    Assert.println((String)("Shutdown was vetoed by " + hook.getClass().getName()));
                    boolean bl = false;
                    return bl;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    Assert.endTiming((String)(this.getClass().getName() + ".canShutdown." + hook.getClass().getName()), (String)hook.getClass().getName(), (String)"  ", (boolean)false);
                }
            }
            // MONITOREXIT : weightedList
            boolean bl = true;
            return bl;
        }
        finally {
            Assert.endTiming((String)(this.getClass().getName() + ".canShutdown"), (String)"Queried ShutdownHooks", null, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        boolean isEmpty;
        WeightedList<ShutdownHook> weightedList = _shutdownHooks;
        synchronized (weightedList) {
            isEmpty = _shutdownHooks.isEmpty();
        }
        if (!isEmpty) {
            try {
                Assert.startTiming((String)(ExitCommand.class.getName() + ".shutdown"), (String)"Calling ShutdownHooks", (boolean)false);
                ExitCommand.invokeShutdownHooks();
            }
            finally {
                Assert.endTiming((String)(ExitCommand.class.getName() + ".shutdown"), (String)"Called ShutdownHooks", null, (boolean)false);
            }
        }
        ExitCommand.shutdownExecutorServices();
    }

    private static void invokeShutdownHooks() {
        if (SwingUtilities.isEventDispatchThread() && !IdeUtil.isHeadless() && !Boolean.getBoolean("ide.suppress.shutdown.progress")) {
            ExitCommand.invokeShutdownHooksWithProgress();
        } else {
            ExitCommand.invokeShutdownHooksImpl(null);
        }
    }

    private static void invokeShutdownHooksWithProgress() {
        final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor((Component)((Object)Ide.getMainWindow()), IdeArb.getString(539), (Object)IdeArb.format(540, Ide.getProgramShortName()), IdeArb.format(541, IdeArb.getString(542)));
        monitor.setModal(true);
        monitor.setCancellable(false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ExitCommand.invokeShutdownHooksImpl(monitor.getPanel());
            }
        };
        RequestProcessor processor = new RequestProcessor("IDE Shutdown", 1);
        RequestProcessor.Task task = processor.post(r);
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                monitor.close();
            }
        });
        try {
            if (!task.waitFinished(500L)) {
                monitor.start();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeShutdownHooksImpl(ProgressPanel progress) {
        ArrayList<ShutdownHook> reverseOrder;
        WeightedList<ShutdownHook> weightedList = _shutdownHooks;
        synchronized (weightedList) {
            reverseOrder = new ArrayList<ShutdownHook>((Collection<ShutdownHook>)_shutdownHooks);
        }
        Collections.reverse(reverseOrder);
        for (ShutdownHook hook : reverseOrder) {
            if (progress != null) {
                Extension extension = ExtensionRegistry.getExtensionRegistry().findExtensionByClassLoader(hook.getClass().getClassLoader());
                if (extension != null) {
                    progress.setNote(IdeArb.format(541, extension.getName()));
                } else {
                    progress.setNote(null);
                }
            }
            try {
                Assert.startTiming((String)(ExitCommand.class.getName() + ".shutdown." + hook.getClass().getName()), null, (boolean)false);
                hook.shutdown();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                Assert.endTiming((String)(ExitCommand.class.getName() + ".shutdown." + hook.getClass().getName()), (String)hook.getClass().getName(), (String)"  ", (boolean)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void shutdownExecutorServices() {
        if (_executors.isEmpty()) {
            return;
        }
        Assert.startTiming((String)(ExitCommand.class.getName() + ".shutdownExecutorServices"), (String)"Shutting down ExecutorService instances", (boolean)false);
        try {
            for (ExecutorServiceRecord record : _executors.values()) {
                Assert.startTiming((String)(ExitCommand.class.getName() + ".shutdownExecutorServices." + record.name), null, (boolean)false);
                boolean success = false;
                try {
                    if (record.immediate) {
                        Executors.shutdownNow((ExecutorService)record.executor);
                    } else {
                        Executors.shutdown((ExecutorService)record.executor);
                    }
                    success = record.executor.awaitTermination(5L, TimeUnit.SECONDS);
                    if (!success) {
                        Assert.println((String)(record.name + " took longer than 5 seconds to shut down"));
                        if (!record.immediate) {
                            Executors.shutdownNow((ExecutorService)record.executor);
                        }
                    }
                    Assert.endTiming((String)(ExitCommand.class.getName() + ".shutdownExecutorServices." + record.name), success ? "Shut down " + record.name : null, (String)"  ", (boolean)false);
                }
                catch (InterruptedException ie) {
                    try {
                        Assert.println((String)("Interrupted while waiting for " + record.name + " to shut down"));
                        Thread.currentThread().interrupt();
                        Assert.endTiming((String)(ExitCommand.class.getName() + ".shutdownExecutorServices." + record.name), success ? "Shut down " + record.name : null, (String)"  ", (boolean)false);
                    }
                    catch (Throwable throwable) {
                        Assert.endTiming((String)(ExitCommand.class.getName() + ".shutdownExecutorServices." + record.name), success ? "Shut down " + record.name : null, (String)"  ", (boolean)false);
                        throw throwable;
                        return;
                    }
                    return;
                }
            }
        }
        finally {
            Assert.endTiming((String)(ExitCommand.class.getName() + ".shutdownExecutorServices"), (String)"Shut down ExecutorService instances", null, (boolean)false);
        }
    }

    @Override
    public int doit() throws Exception {
        if (!this.canShutdown()) {
            return 1;
        }
        View view = (View)this.getData();
        if (view == null) {
            view = Ide.getMainWindow().getIdeMainWindowView();
        }
        boolean skipSaveAll = this.getContext().containsProperty(SKIP_SAVE_ALL);
        boolean silentSaveAll = this.getContext().containsProperty(SILENT_SAVE_ALL);
        this.doSaveAll(skipSaveAll, silentSaveAll);
        ArrayList<Node> sysNodes = new ArrayList<Node>();
        ArrayList<Node> dirtyNodes = new ArrayList<Node>();
        this.collectNodes(sysNodes, dirtyNodes, skipSaveAll);
        boolean[] saveOptions = new boolean[]{true, true};
        CheckBoxListModel listModel = this.doSaveNodes(dirtyNodes, saveOptions, skipSaveAll, silentSaveAll);
        boolean doClose = saveOptions[0];
        boolean saveNone = saveOptions[1];
        if (doClose) {
            this.sanitizeWorkspaces(listModel, saveNone);
            listModel = null;
            listModel = new CheckBoxListModel();
            for (Node node : sysNodes) {
                URL url = node.getURL();
                if (node.isReadOnly()) {
                    URLFileSystem.setReadOnly((URL)url, (boolean)false);
                }
                try {
                    node.save();
                }
                catch (Exception e) {
                    listModel.addElement((Object)node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName((URL)url));
                }
            }
            if (listModel.getSize() > 0) {
                boolean bl = doClose = silentSaveAll ? true : this.exitWithUnsavedReadOnlyFiles(listModel, IdeArb.getString(293));
            }
            if (doClose) {
                view.close();
                ExitCommand.shutdown();
                int status = this.getContext().getInt(EXIT_STATUS);
                Ide.getMainWindow().beforeShutDown(status);
            }
        }
        return doClose ? 0 : 1;
    }

    private CheckBoxListModel doSaveNodes(List<Node> dirtyNodes, boolean[] saveOptions, boolean skipSaveAll, boolean silentSaveAll) {
        if (skipSaveAll) {
            return new CheckBoxListModel();
        }
        FilesToSaveOnCloseCollector collector = FilesToSaveOnCloseCollector.collectFilesToSave(dirtyNodes);
        CheckBoxListModel listModel = FilesToSaveModelBuilder.filesToSave(collector);
        if (listModel.getSize() > 0) {
            int response = silentSaveAll ? 0 : SelectFilesPanel.showDialog(IdeArb.getString(289), IdeArb.format(216, listModel.findTextForElement(0)), IdeArb.getString(219), listModel, true, 1, "f1_idedsavefiles_html", collector.actionDescription());
            switch (response) {
                case 0: {
                    saveOptions[1] = false;
                    List list = listModel.getSelectionList();
                    Iterator iterator = null;
                    if (list != null) {
                        iterator = list.iterator();
                    }
                    listModel = null;
                    listModel = new CheckBoxListModel();
                    while (iterator != null && iterator.hasNext()) {
                        Object next = iterator.next();
                        if (!(next instanceof Node)) continue;
                        Node node = (Node)next;
                        URL url = node.getURL();
                        if (node.isReadOnly()) {
                            URLFileSystem.setReadOnly((URL)url, (boolean)false);
                        }
                        try {
                            node.save();
                        }
                        catch (Exception e) {
                            String pathName = URLFileSystem.getPlatformPathName((URL)url);
                            String label = String.format("%s. (%s)", pathName, e.getMessage());
                            listModel.addElement((Object)node, node.getIcon(), true, true, label);
                        }
                    }
                    if (listModel.getSize() <= 0) break;
                    saveOptions[0] = silentSaveAll ? true : this.exitWithUnsavedReadOnlyFiles(listModel, IdeArb.getString(290));
                    break;
                }
                case -1: 
                case 2: {
                    saveOptions[0] = false;
                }
            }
        }
        return listModel;
    }

    private void doSaveAll(boolean skipSaveAll, boolean silentSaveAll) {
        if (skipSaveAll) {
            return;
        }
        if (EnvironOptions.getInstance(Preferences.getPreferences()).getSaveOnDeactivation()) {
            try {
                SaveAllCommand.saveAll(silentSaveAll);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    private void collectNodes(List<Node> sysNodes, List<Node> dirtyNodes, boolean skipSaveAll) {
        if (skipSaveAll) {
            return;
        }
        Iterator<Node> openNodesIter = NodeFactory.getOpenNodes();
        while (openNodesIter.hasNext()) {
            Node node = openNodesIter.next();
            if (node.isDirty()) {
                if (!(!node.getAttributes().isSet(ElementAttributes.SAVEABLE) || node instanceof Project && ((Project)node).isDefault())) {
                    dirtyNodes.add(node);
                    continue;
                }
                sysNodes.add(node);
                continue;
            }
            if (node instanceof Workspace) {
                try {
                    ((Workspace)node).saveUserProperties();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(node instanceof Project)) continue;
            try {
                ((Project)node).saveUserProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean exitWithUnsavedReadOnlyFiles(CheckBoxListModel listModel, String title) {
        int response = SelectFilesPanel.showDialog(title, IdeArb.format(292, listModel.findTextForElement(0)), IdeArb.getString(291), listModel, false, 2, "f1_idedunabletosavefiles_html");
        return response == 0;
    }

    private void sanitizeWorkspaces(CheckBoxListModel listModel, boolean saveNone) {
        if (listModel == null || listModel.getSize() == 0) {
            return;
        }
        Workspaces workspaces = (Workspaces)Ide.getSystem().getChild(Workspaces.class);
        if (workspaces == null) {
            return;
        }
        int numFiles = listModel.getSize();
        for (int i = 0; i < numFiles; ++i) {
            Node node;
            if (!saveNone && listModel.isElementSelected(i) || !(node = (Node)listModel.getUserObjectAt(i)).isOpen() || !(node instanceof Workspace) || !node.isNew()) continue;
            workspaces.remove(node);
        }
    }

    private static final class ExecutorServiceRecord {
        private final ExecutorService executor;
        private final String name;
        private final boolean immediate;

        private ExecutorServiceRecord(ExecutorService executor, String name, boolean immediate) {
            this.executor = executor;
            this.name = name;
            this.immediate = immediate;
        }
    }
}

