/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.cmd.FilesToSaveModelBuilder;
import oracle.ide.cmd.FilesToSaveOnCloseCollector;
import oracle.ide.cmd.RemoveFileCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.layout.IdeLayout;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;

public class CloseNodeCommand
extends Command {
    private List affectedNodes = new ArrayList(1);
    private final UpdateMessage _messageTemplate;
    private boolean _confirm = true;

    public CloseNodeCommand() {
        this(null);
    }

    public CloseNodeCommand(UpdateMessage messageTemplate) {
        super(20, 1);
        this._messageTemplate = messageTemplate != null ? messageTemplate.copyMessage() : new UpdateMessage(UpdateMessage.NO_MESSAGE, null);
    }

    @Deprecated
    public static Command removeOrCloseApplicationPrompt(Context context) {
        return CloseNodeCommand.closeAndremoveApplication(context);
    }

    public static Command closeAndremoveApplication(Context context) {
        return CommandProcessor.createCommandFromAction(21, context);
    }

    @Override
    public int doit() throws Exception {
        Context context = this.getContext();
        Element[] selection = context.getSelection();
        ArrayList nodes = new ArrayList();
        if (selection != null) {
            if (CloseNodeCommand.workspaceIsSelected(selection)) {
                Command command = CloseNodeCommand.closeAndremoveApplication(context);
                if (command == null) {
                    return 1;
                }
                if (command.getId() == 21) {
                    return CommandProcessor.getInstance().invoke(command);
                }
            }
            int n = selection.length;
            for (int i = 0; i < n; ++i) {
                CloseNodeCommand.checkShouldClose(selection[i], nodes);
            }
        } else {
            CloseNodeCommand.checkShouldClose(context.getNode(), nodes);
        }
        int status = this.close(nodes, false, true);
        return status;
    }

    private static boolean workspaceIsSelected(Element[] selection) {
        return selection.length > 0 && selection[0] instanceof Workspace;
    }

    public boolean isNeedConfirm() {
        return this._confirm;
    }

    public void setNeedConfirm(boolean confirm) {
        this._confirm = confirm;
    }

    private void notifyNodesClosing(List nodes) {
        UpdateMessage change = this._messageTemplate.forNewMessageID(UpdateMessage.OBJECT_CLOSING);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            node.notifyObservers(node, change);
        }
    }

    private void recCollectClosingNodes(Iterator nodes, List closingNodes) {
        this.collectAffectedNodes(nodes, new ArrayList(), closingNodes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close(List nodes, boolean uncache, boolean removeUnsavedNodes) {
        ArrayList dirtyNodes = new ArrayList();
        ArrayList loadedNodes = new ArrayList();
        PerformanceLogger.get().startTiming("CloseNodeCommand.close");
        try {
            this.collectAffectedNodes(nodes.iterator(), dirtyNodes, loadedNodes, true);
        }
        finally {
            PerformanceLogger.get().stopTiming("CloseNodeCommand.close", "CloseNodeCommand.collectAffectedNodes()", 200);
        }
        int status = this.checkSave(dirtyNodes, true);
        if (status != 0) {
            return status;
        }
        return this.close(loadedNodes, this.getContext(), uncache, removeUnsavedNodes);
    }

    public int close(Node node, boolean uncache, boolean removeUnsavedNode) {
        if (!node.isLoaded()) {
            return 0;
        }
        return this.close(Collections.singletonList(node), uncache, removeUnsavedNode);
    }

    public int close(Node node) {
        if (!node.isLoaded()) {
            return 0;
        }
        ArrayList dirtyNodes = new ArrayList();
        ArrayList loadedNodes = new ArrayList();
        this.collectAffectedNodes(Collections.singletonList(node).iterator(), dirtyNodes, loadedNodes, true);
        this.checkSave(dirtyNodes, false);
        return this.close(loadedNodes, this.getContext(), false, true);
    }

    @Override
    public Node[] getAffectedNodes() {
        Node[] nodes = new Node[this.affectedNodes.size()];
        this.affectedNodes.toArray(nodes);
        return nodes;
    }

    public void clearAffectedNodes() {
        this.affectedNodes.clear();
    }

    public int checkSave(Iterator targets) {
        return this.checkSave(targets, true);
    }

    public int checkSave(Iterator targets, boolean canCancel) {
        ArrayList dirtyNodes = new ArrayList();
        this.collectDirtyNodes(targets, dirtyNodes);
        return this.checkSave(dirtyNodes, canCancel);
    }

    public int checkSave(List dirtyNodes, boolean canCancel) {
        int response;
        if (dirtyNodes.size() == 0) {
            return 0;
        }
        FilesToSaveOnCloseCollector collector = FilesToSaveOnCloseCollector.collectFilesToSave(dirtyNodes);
        CheckBoxListModel listModel = FilesToSaveModelBuilder.filesToSave(collector);
        int status = 1;
        if (this.isNeedConfirm()) {
            int options = 1;
            if (!canCancel) {
                options = 0;
            }
            response = SelectFilesPanel.showDialog(IdeArb.getString(289), IdeArb.format(216, listModel.findTextForElement(0)), IdeArb.getString(219), listModel, true, options, "f1_idedsavefiles_html", collector.actionDescription());
        } else {
            response = 0;
        }
        if (response == 0) {
            int closeAnyway;
            CheckBoxListModel notSavedListModel = new CheckBoxListModel();
            int numFiles = listModel.getSize();
            for (int i = 0; i < numFiles; ++i) {
                Object userObject = listModel.getUserObjectAt(i);
                if (!(userObject instanceof Node)) continue;
                Node doc = (Node)userObject;
                if (listModel.isElementSelected(i)) {
                    try {
                        if (IdeAction.DEBUG) {
                            Logger.getAnonymousLogger().info("Saving doc - Long label:" + doc.getLongLabel() + " Short label " + doc.getShortLabel() + " Class: " + doc.getClass());
                        }
                        doc.save();
                    }
                    catch (IOException e) {
                        String label = String.format("%s. (%s)", doc.getLongLabel(), e.getMessage());
                        notSavedListModel.addElement((Object)doc, doc.getIcon(), true, true, label);
                    }
                    continue;
                }
                if (!collector.onlyOneFileToCloseWithDirtyGroupedFiles() || dirtyNodes.contains(doc) || !doc.isDirty() || !collector.isGrouped(doc)) continue;
                try {
                    doc.revert();
                    CommandProcessor.getInstance().flush(doc);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            int listSize = notSavedListModel.getSize();
            status = listSize > 0 ? (this.isNeedConfirm() ? ((closeAnyway = SelectFilesPanel.showDialog(IdeArb.getString(290), IdeArb.format(286, notSavedListModel.findTextForElement(0)), IdeArb.getString(285), notSavedListModel, false, 2, "f1_idedunabletosavefiles_html")) == 0 ? 0 : 1) : 1) : 0;
        } else if (response == 1) {
            status = 0;
        }
        return status;
    }

    public int close(Iterator nodes, Context context, boolean uncache, boolean removeUnsavedNodes) {
        ArrayList nodeList = new ArrayList();
        this.recCollectClosingNodes(nodes, nodeList);
        return this.close(nodeList, context, uncache, removeUnsavedNodes);
    }

    protected int close(List nodes, Context context, boolean uncache, boolean removeUnsavedNodes) {
        this.notifyNodesClosing(nodes);
        return this.closeNoNotify(nodes, context, uncache, removeUnsavedNodes);
    }

    private int closeNoNotify(List nodes, Context context, boolean uncache, boolean removeUnsavedNodes) {
        UpdateMessage update = this._messageTemplate.forNewMessageID(UpdateMessage.OBJECT_CLOSED);
        update.setContext(context);
        ArrayList<Node> unsavedNodes = new ArrayList<Node>();
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            Object obj = nodes.get(i);
            if (!(obj instanceof Node)) continue;
            final Node doc = (Node)obj;
            if (doc instanceof Project && context.getProject() != doc) {
                Context ideCtx = new Context(context);
                ideCtx.setProject((Project)doc);
                context = ideCtx;
            }
            try {
                doc.notifyObservers(doc, update);
                if (SwingUtilities.isEventDispatchThread()) {
                    doc.close();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                doc.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                if (removeUnsavedNodes && !URLFileSystem.exists((URL)doc.getURL())) {
                    unsavedNodes.add(doc);
                }
                this.affectedNodes.add(doc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!uncache) continue;
            NodeFactory.uncache(doc.getURL());
        }
        if (unsavedNodes.size() > 0) {
            this.removeUnsavedNodes(unsavedNodes, context);
        }
        return 0;
    }

    private void collectAffectedNodes(Iterator targets, List dirtyNodes, List loadedNodes, boolean collectLoaded) {
        while (targets.hasNext()) {
            Iterator iter;
            Element element = (Element)targets.next();
            if (element == null) continue;
            if (element instanceof Node) {
                Node doc = (Node)element;
                if (!dirtyNodes.contains(doc) && doc.isDirty() && doc.getAttributes().isSet(ElementAttributes.SAVEABLE)) {
                    dirtyNodes.add(doc);
                }
                if (!doc.isLoaded() || loadedNodes.contains(doc)) continue;
                if (doc.mayHaveChildren()) {
                    boolean docCollectLoaded;
                    boolean bl = !collectLoaded ? false : (docCollectLoaded = !doc.getTransientProperties().containsKey("PROJECT.reload.external.change"));
                    if (doc instanceof Project) {
                        this.collectAffectedNodesFromProject((Project)doc, dirtyNodes, loadedNodes, docCollectLoaded);
                    } else {
                        Iterator iter2;
                        if (doc instanceof Workspace) {
                            this.collectAffectedNodesFromWorkspace((Workspace)doc, dirtyNodes, loadedNodes, docCollectLoaded);
                        }
                        if ((iter2 = doc.getChildren()) != null) {
                            this.collectAffectedNodes(iter2, dirtyNodes, loadedNodes, docCollectLoaded);
                        }
                    }
                }
                loadedNodes.add(doc);
                continue;
            }
            if (element instanceof LazyLoadable && !((LazyLoadable)((Object)element)).isOpen() || !element.mayHaveChildren() || (iter = element.getChildren()) == null) continue;
            this.collectAffectedNodes(iter, dirtyNodes, loadedNodes, true);
        }
    }

    private void collectAffectedNodesFromWorkspace(Workspace workspace, List dirtyNodes, List loadedNodes, boolean collectLoaded) {
        ContentSet content = ApplicationContent.getInstance(workspace).getAllContents();
        this.collectAffectedNodesFromContentSet(content, dirtyNodes, loadedNodes, collectLoaded);
    }

    private void collectAffectedNodesFromProject(Project project, List dirtyNodes, List loadedNodes, boolean collectLoaded) {
        ContentSet content = ProjectContent.getInstance(project).getAllContents();
        this.collectAffectedNodesFromContentSet(content, dirtyNodes, loadedNodes, collectLoaded);
    }

    private void collectAffectedNodesFromContentSet(ContentSet content, List dirtyNodes, List loadedNodes, boolean collectLoaded) {
        Iterator<Node> targets = NodeFactory.getOpenNodes();
        while (targets.hasNext()) {
            Node doc = targets.next();
            if (this.isSystemNode(doc) || !content.canHaveMember(doc.getURL())) continue;
            if (doc.isDirty() && !dirtyNodes.contains(doc) && doc.getAttributes().isSet(ElementAttributes.SAVEABLE)) {
                dirtyNodes.add(doc);
            }
            if (!doc.isLoaded() || !collectLoaded) continue;
            loadedNodes.add(doc);
        }
    }

    private boolean isSystemNode(Node doc) {
        if (doc instanceof Project || doc instanceof Workspace || doc instanceof IdeSystem || doc instanceof IdeLayout) {
            return true;
        }
        if (doc.getURL() == null) {
            throw new IllegalArgumentException("A node of class " + doc.getClass() + " is open, but returning null from getURL().");
        }
        String suffix = URLFileSystem.getSuffix((URL)doc.getURL());
        return ".library".equals(suffix) || ".jdk".equals(suffix);
    }

    protected void collectDirtyNodes(Iterator targets, List dirtyNodes) {
        this.collectAffectedNodes(targets, dirtyNodes, new ArrayList(), true);
    }

    private static void checkShouldClose(Element element, ArrayList nodes) {
        Node node;
        if (element instanceof Node && (node = (Node)element).isLoaded()) {
            nodes.add(node);
        }
    }

    private void removeUnsavedNodes(List unsavedNodes, Context context) {
        HashMap<Folder, ArrayList<Node>> ownersMap = new HashMap<Folder, ArrayList<Node>>();
        for (Node doc : unsavedNodes) {
            Folder owner = Workspaces.findOwner(doc, context);
            if (owner == null || !owner.canRemove(doc)) continue;
            ArrayList<Node> list = (ArrayList<Node>)ownersMap.get(owner);
            if (list == null) {
                list = new ArrayList<Node>();
                ownersMap.put(owner, list);
            }
            list.add(doc);
            NodeFactory.uncache(doc.getURL());
        }
        RemoveFileCommand remCmd = new RemoveFileCommand();
        remCmd.setContext(context);
        for (Map.Entry entry : ownersMap.entrySet()) {
            Folder owner = (Folder)entry.getKey();
            List list = (List)entry.getValue();
            remCmd.remove(list, owner, false);
        }
    }
}

