/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.adapters;

import java.util.Map;
import oracle.ide.adapters.AdapterFactory;
import oracle.javatools.util.Maps;

public abstract class AbstractCachingAdapterFactory<A, T>
implements AdapterFactory<A, T> {
    public static final int DEFAULT_MAX_CACHE_SIZE = 100;
    private final Map<A, T> cache = new Maps.CacheMap(100, Maps.CacheMap.WEAK);

    protected int getMaxCacheSize() {
        return 100;
    }

    protected synchronized boolean shouldRemoveFromCache(Map.Entry<A, T> entry) {
        return this.cache.size() >= this.getMaxCacheSize();
    }

    protected final synchronized T findInCache(A adaptable) {
        return this.cache.get(adaptable);
    }

    protected final synchronized void addToCache(A adaptable, T target) {
        this.cache.put(adaptable, target);
    }

    protected final synchronized void removeFromCache(A adaptable) {
        this.cache.remove(adaptable);
    }

    protected final synchronized void clearCache() {
        this.cache.clear();
    }

    @Override
    public final T adapt(A obj) {
        if (null == obj) {
            throw new IllegalArgumentException("Adaptable object must not be null");
        }
        T target = this.findInCache(obj);
        if (null == target) {
            target = this.adaptImpl(obj);
            this.addToCache(obj, target);
        }
        return target;
    }

    public abstract T adaptImpl(A var1);
}

