/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.access;

import java.io.File;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.AccessExecutor;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.MSAccessPlugin;
import oracle.dbtools.migration.workbench.plugin.MSAccessXMLExporterFileParser;
import oracle.dbtools.migration.workbench.plugin.Messages;
import oracle.dbtools.migration.workbench.plugin.access.MSAccessInstallLocator;

public class MSAccessOnlineCapturer
extends AbstractOnlineCapturer {
    private static final String ACCESS_EXE_NAME = "MSACCESS.EXE";
    private String m_mdbFile;
    private boolean m_alreadyCaptured;
    private File m_movedFile = null;
    private String m_originalName;

    public MSAccessOnlineCapturer(MigrationStorer migrationStorer, Connection connection, String string) {
        super(migrationStorer, connection);
        this.m_mdbFile = string;
        this.m_alreadyCaptured = false;
    }

    public CaptureQueries getCaptureQueries() {
        return new CaptureQueries(){

            public String getQueryForType(String string, MigrationObjectFilter migrationObjectFilter) {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        if (this.m_alreadyCaptured) {
            return;
        }
        String string2 = this.executeAccessExporter(captureContext);
        if (string2 == null) {
            if (this.m_movedFile != null) {
                MSAccessOnlineCapturer.moveBack(this.m_movedFile, this.m_originalName);
            }
            return;
        }
        MSAccessXMLExporterFileParser mSAccessXMLExporterFileParser = new MSAccessXMLExporterFileParser(string2, this.getStorer(), captureContext);
        try {
            if (!mSAccessXMLExporterFileParser.loadFile()) {
                throw new CaptureException((Throwable)new IllegalStateException(Messages.getString("MSAccessOnlineCapturer.1")));
            }
        }
        finally {
            if (this.m_movedFile != null) {
                MSAccessOnlineCapturer.moveBack(this.m_movedFile, this.m_originalName);
            }
        }
        this.m_alreadyCaptured = true;
    }

    private static void moveBack(File file, String string) {
        File file2 = new File(string);
        String string2 = MSAccessMigrationAddinArb.format("MSG_TEMP_MOVE_BACK", file.getAbsoluteFile(), string);
        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.FINE, string2);
        file.renameTo(file2);
    }

    public String getModelName() throws CaptureException {
        return MSAccessPlugin.getModelNameFromMDBFileName(this.m_mdbFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeAccessExporter(CaptureContext captureContext) throws CaptureException {
        String string;
        MSAccessInstallLocator mSAccessInstallLocator = new MSAccessInstallLocator();
        MSAccessInstallLocator.AccessInstallInfo[] accessInstallInfoArray = mSAccessInstallLocator.getInstalledVersions();
        if (accessInstallInfoArray == null || accessInstallInfoArray.length == 0) {
            throw new CaptureException((Throwable)new IllegalStateException(MSAccessMigrationAddinArb.getString("MSG_COULDNT_LOCATE_ACCESS")));
        }
        String string2 = accessInstallInfoArray[0].getInstallLocation() + ACCESS_EXE_NAME;
        AccessExecutor accessExecutor = new AccessExecutor(string2, string = MSAccessPlugin.getMDEFileForVersion(accessInstallInfoArray[0].getVersion()), this.m_mdbFile, null, true, false, false);
        String string3 = accessExecutor.getMonitorFile();
        File file = new File(string3);
        if (file.exists()) {
            this.temporarilyMoveFile(file);
        }
        CaptureEvent captureEvent = new CaptureEvent(6, "MDBFILE", this.m_mdbFile);
        captureContext.getAudience().fireListeners(captureEvent);
        accessExecutor.start();
        captureEvent = new CaptureEvent(8, MessageFormat.format(Messages.getString("MSAccessOnlineCapturer.1"), string3), null);
        captureContext.getAudience().fireListeners(captureEvent);
        while (true) {
            if (file.exists()) {
                captureEvent.setEventSubject((Object)Messages.getString("MSAccessOnlineCapturer.4"));
                captureContext.getAudience().fireListeners(captureEvent);
                return string3;
            }
            if (captureContext.shouldCancel()) {
                return null;
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                if (captureContext.shouldCancel()) return null;
                continue;
            }
            break;
        }
    }

    private void temporarilyMoveFile(File file) {
        File file2 = file;
        while (file2.exists()) {
            int n = (int)(Math.random() * 10000.0);
            String string = file.getAbsolutePath() + "." + n;
            file2 = new File(string);
        }
        this.m_originalName = file.getAbsolutePath();
        String string = MSAccessMigrationAddinArb.format("MSG_TEMP_MOVE", this.m_originalName, file2.getAbsoluteFile());
        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.FINE, string);
        file.renameTo(file2);
        this.m_movedFile = file2;
    }
}

