/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.workbench.plugin.common.InvalidDatabaseException;
import oracle.dbtools.migration.workbench.plugin.common.LinkTableDescriptor;
import oracle.dbtools.migration.workbench.plugin.common.MSAccessUtils;
import oracle.dbtools.migration.workbench.plugin.common.UnableToModifyAccessDatabaseException;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoDatabase;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoException;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoWorkspace;

public class MSAccessPostMigration {
    private String m_oracleConn;
    private String m_accessConn;
    private boolean m_removeSrcTables;
    private DBObjectId m_convertedModelId;
    private JDaoWorkspace m_daoWorkspace;
    private String oracleDSN = "";

    public MSAccessPostMigration(String string, String string2, boolean bl, MdConnection mdConnection, String string3) {
        this.m_oracleConn = string;
        this.m_accessConn = string2;
        this.m_removeSrcTables = bl;
        this.m_convertedModelId = mdConnection.getKey();
        this.oracleDSN = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPostMigration() {
        if (!MSAccessUtils.confirmDaoVersion(this.m_accessConn)) {
            return false;
        }
        try {
            this.m_daoWorkspace = MSAccessUtils.getDAOWorkspace(this.m_accessConn);
            String string = MSAccessUtils.getOdbcFromConnection(this.m_accessConn);
            String string2 = MSAccessUtils.getPathAndFileName(string);
            if (!MSAccessUtils.ensureValidDatabase(string2, false, false)) {
                boolean bl = false;
                return bl;
            }
            JDaoDatabase jDaoDatabase = new JDaoDatabase();
            jDaoDatabase.open(string2, true, false);
            ArrayList<LinkTableDescriptor> arrayList = MSAccessUtils.getTablesInfo(this.m_convertedModelId);
            for (LinkTableDescriptor linkTableDescriptor : arrayList) {
                MSAccessUtils.createTableAttachment(jDaoDatabase, string, linkTableDescriptor, this.m_oracleConn, true, true);
                MSAccessUtils.createMappingQuery(jDaoDatabase, linkTableDescriptor);
            }
        }
        catch (JDaoException jDaoException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, jDaoException.getStackTrace()[0].toString(), jDaoException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
        catch (InvalidDatabaseException invalidDatabaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, invalidDatabaseException.getStackTrace()[0].toString(), invalidDatabaseException);
        }
        catch (UnableToModifyAccessDatabaseException unableToModifyAccessDatabaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unableToModifyAccessDatabaseException.getStackTrace()[0].toString(), unableToModifyAccessDatabaseException);
        }
        finally {
            this.m_daoWorkspace.deinit();
            this.m_daoWorkspace = null;
        }
        return true;
    }
}

