/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.adfdtinternal.model.dvt.util.gui.BIFontPane;
import oracle.bali.ewt.chooser.font.FontPreviewArea;
import oracle.dss.dataView.gui.NumberFormatPanel;
import oracle.dss.dataView.managers.ViewFormat;

public class FormatPreviewArea
extends FontPreviewArea
implements PropertyChangeListener {
    private ViewFormat m_viewFormat = null;
    private String m_sampleString;
    private ResourceBundle rBundle = null;
    private ResourceBundle rUtilBundle = null;
    private int m_numType = 0;
    private boolean negRed = false;
    private boolean isDateFormat = false;
    private char m_thousandSeparator = '\u0000';
    private char m_noThousandSeparator = '\u0000';
    protected NumberFormatPanel m_numberPanel = null;
    protected BIFontPane m_fontPane = null;

    public FormatPreviewArea(BIFontPane fontPane, NumberFormatPanel numberPanel) {
        this.m_fontPane = fontPane;
        this.m_numberPanel = numberPanel;
        if (this.m_numberPanel != null) {
            if (numberPanel.getViewFormat() != null) {
                this.updateResourceBundle(numberPanel.getViewFormat().getLocale());
            } else {
                this.updateResourceBundle(numberPanel.getLocale());
            }
            this.m_sampleString = "-1234.5";
            this.isDateFormat = false;
            this.setPreviewText(this.m_sampleString);
            this.m_numberPanel.addPropertyChangeListener(this);
            if (this.m_numberPanel.getViewFormat() != null) {
                this.m_viewFormat = (ViewFormat)this.m_numberPanel.getViewFormat().clone();
                this.m_numType = this.m_viewFormat.getNumberType();
                this.setNegativeFormat(this.m_numberPanel.getNegativeFormat());
            } else {
                this.m_viewFormat = null;
            }
        } else {
            this.m_sampleString = "";
            this.updateResourceBundle(null);
        }
        this.setPreviewText(this.m_sampleString);
        if (this.m_fontPane != null) {
            this.setFontPane(this.m_fontPane);
        }
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, Integer.parseInt(this.rBundle.getString("FormatPreviewPanelHeight"))));
    }

    public void setNumberFormatPanel(NumberFormatPanel numberPanel) {
        this.m_numberPanel.removePropertyChangeListener(this);
        this.m_numberPanel = numberPanel;
        if (this.m_numberPanel != null) {
            if (numberPanel.getViewFormat() != null) {
                this.updateResourceBundle(numberPanel.getViewFormat().getLocale());
            } else {
                this.updateResourceBundle(numberPanel.getLocale());
            }
            this.m_sampleString = "-1234.5";
            this.isDateFormat = false;
            this.setPreviewText(this.m_sampleString);
            this.m_numberPanel.addPropertyChangeListener(this);
            if (this.m_numberPanel.getViewFormat() != null) {
                this.m_viewFormat = this.m_numberPanel.apply();
                this.m_numType = this.m_viewFormat.getNumberType();
                this.setNegativeFormat(this.m_numberPanel.getNegativeFormat());
            } else {
                this.m_viewFormat = null;
            }
        }
        this.updateText();
    }

    public void updateText() {
        String value = "";
        if (this.m_viewFormat != null) {
            double dValue = new Double(this.m_sampleString);
            if (dValue < 0.0 && this.negRed) {
                super.setForeground(Color.red);
            }
            value = ((ViewFormat)this.m_viewFormat.clone()).DoubleToString(dValue);
        } else {
            value = this.m_sampleString;
        }
        this.setPreviewText(value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.processEvent(e);
    }

    public void processEvent(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (e.getSource() == this.m_numberPanel) {
            if (propertyName.equals("DecimalPlaces")) {
                this.setDecimalPlaces((Integer)e.getNewValue());
            } else if (propertyName.equals("ThousandSeparator")) {
                this.setThousandSeparator((Boolean)e.getNewValue());
            } else if (propertyName.equals("Scale")) {
                this.setScale((Boolean)e.getNewValue());
            } else if (propertyName.equals("ScaleFactor")) {
                this.setScaleSign((Integer)e.getNewValue());
            } else if (propertyName.equals("ScaleSign")) {
                this.setScaleSignMarker((Boolean)e.getNewValue());
            } else if (propertyName.equals("NegativeNumberTypeChange")) {
                this.setNegativeFormat(this.m_numberPanel.getNegativeFormat());
            } else if (propertyName.equals("TypeChange")) {
                int type = (Integer)e.getNewValue();
                this.setNumberFormatType(type);
                if (type != 2 && type != 3) {
                    this.setNegativeRed(false);
                } else {
                    this.setNegativeRed(this.m_numberPanel.isNegativeRed());
                }
            } else if (propertyName.equals("CustomTypeChange")) {
                this.setNumberCustomType((String)e.getNewValue());
            } else if (propertyName.equals("DollarSign")) {
                this.setDollarSign((String)e.getNewValue());
            } else if (propertyName.equals("PositiveFormat")) {
                this.setPositiveFormat((Integer)e.getNewValue());
            } else if (propertyName.equals("CurrencySymbolUsed")) {
                this.setCurrencySymbolUsed((Boolean)e.getNewValue());
            }
        }
        this.updateText();
    }

    public void setNegativeRed(boolean r) {
        this.negRed = r;
    }

    private void setDecimalPlaces(int numPlaces) {
        this.m_viewFormat.setDecimalDigit(numPlaces);
    }

    private void setThousandSeparator(boolean sep) {
        this.m_viewFormat.setThousandSeparatorUsed(sep);
        if (!sep) {
            this.m_viewFormat.setThousandSeparator(this.m_noThousandSeparator);
        } else {
            this.m_viewFormat.setThousandSeparator(this.m_thousandSeparator);
        }
    }

    private void setScale(boolean scale) {
        this.m_viewFormat.setScaleFactorUsed(scale);
        if (!scale) {
            this.m_viewFormat.setScaleFactor(0);
        } else {
            this.setScaleSign(this.m_numberPanel.getScaleFactor());
        }
    }

    private void setScaleSign(int scale) {
        this.m_viewFormat.setScaleFactor(scale);
        this.setScaleSignMarker(this.m_numberPanel.isShowScaleMark());
    }

    private void setScaleSignMarker(boolean scale) {
        switch (this.m_viewFormat.getScaleFactor()) {
            case 0: {
                break;
            }
            case 1: {
                if (scale) {
                    this.m_viewFormat.setScaleDownThousands(this.rUtilBundle.getString("K"));
                    break;
                }
                this.m_viewFormat.setScaleDownThousands("");
                break;
            }
            case 2: {
                if (scale) {
                    this.m_viewFormat.setScaleDownMillions(this.rUtilBundle.getString("M"));
                    break;
                }
                this.m_viewFormat.setScaleDownMillions("");
                break;
            }
            case 3: {
                if (scale) {
                    this.m_viewFormat.setScaleDownBillions(this.rUtilBundle.getString("B"));
                    break;
                }
                this.m_viewFormat.setScaleDownBillions("");
                break;
            }
            case 4: {
                if (scale) {
                    this.m_viewFormat.setScaleDownTrillions(this.rUtilBundle.getString("T"));
                    break;
                }
                this.m_viewFormat.setScaleDownTrillions("");
                break;
            }
            case 5: {
                if (scale) {
                    this.m_viewFormat.setScaleDownQuadrillions(this.rUtilBundle.getString("Q"));
                    break;
                }
                this.m_viewFormat.setScaleDownQuadrillions("");
            }
        }
    }

    private void setNegativeFormat(int nf) {
        if (this.m_numType == 0) {
            this.m_viewFormat.setNegNumFmt(nf);
        } else if (this.m_numType == 1) {
            this.m_viewFormat.setNegCurFmt(nf);
        }
    }

    private void setNumberFormatType(int type) {
        switch (type) {
            case 6: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                break;
            }
            case 0: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                break;
            }
            case 1: {
                this.m_viewFormat = new ViewFormat(this.m_numberPanel.getDefaultFormat(), 1);
                this.m_viewFormat.setLocale(super.getLocale());
                break;
            }
            case 2: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                this.m_viewFormat.setNumberType(0);
                this.m_numType = 0;
                this.setDecimalPlaces(this.m_numberPanel.getDecimalPlaces());
                this.setThousandSeparator(this.m_numberPanel.isShowThousandSeparator());
                this.setScale(this.m_numberPanel.isScale());
                this.setNegativeFormat(this.m_numberPanel.getNegativeFormat());
                break;
            }
            case 3: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                this.m_viewFormat.setNumberType(1);
                this.m_numType = 1;
                this.setCurrencySymbolUsed(this.m_numberPanel.isShowCurrencySymbol());
                this.setDecimalPlaces(this.m_numberPanel.getDecimalPlaces());
                this.setThousandSeparator(this.m_numberPanel.isShowThousandSeparator());
                this.setScale(this.m_numberPanel.isScale());
                this.setNegativeFormat(this.m_numberPanel.getNegativeFormat());
                break;
            }
            case 4: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                this.m_viewFormat.setNumberType(2);
                this.m_numType = 2;
                this.setDecimalPlaces(this.m_numberPanel.getDecimalPlaces());
                break;
            }
            case 5: {
                this.setNumberCustomType(this.m_numberPanel.getCurrentCustomPatternString());
            }
        }
    }

    private void setNumberCustomType(String nf) {
        try {
            this.m_viewFormat = new ViewFormat(nf, 1);
            this.m_viewFormat.setLocale(super.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setDollarSign(String sign) {
        this.m_viewFormat.setCurrencySymbol(sign);
        this.m_viewFormat.setCurrencySymbolUsed(true);
        this.m_viewFormat.setNumberType(1);
        this.m_numType = 1;
        this.updateText();
    }

    private void setPositiveFormat(int position) {
        this.m_viewFormat.setPosCurFmt(position);
        this.updateText();
    }

    private void setCurrencySymbolUsed(boolean used) {
        this.m_viewFormat.setCurrencySymbolUsed(used);
        if (used) {
            this.setDollarSign(this.m_numberPanel.getDollarSign());
        } else {
            this.setDollarSign("");
        }
        this.updateText();
    }

    private void setDateFormatChanged(String newFormat) {
        if (this.m_viewFormat == null) {
            this.m_viewFormat = new ViewFormat();
        }
        this.m_viewFormat.setOracleDateFormat(newFormat);
    }

    private void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc);
            this.rUtilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle", loc);
        } else {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
            this.rUtilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle");
        }
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        if (this.m_viewFormat != null) {
            this.m_viewFormat.setLocale(loc);
        }
    }
}

