/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.ObjectChildElement;
import oracle.ideimpl.db.explorer.model.PropertyNode;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.DynamicPropertySet;

final class PropertiesFolder
extends PropertyNode
implements ObjectChildElement {
    public PropertiesFolder(PropertyInfo info, Object parentObject, DBObjectProvider pro) {
        super(info, parentObject, pro, true);
    }

    @Override
    protected List<Element> createChildren(List<Element> existing) throws CancelledException {
        ArrayList<Element> retval = new ArrayList<Element>();
        Object parentObj = this.getParentObject();
        if (parentObj instanceof DBObject) {
            PropertyInfo info = this.getPropertyInfo();
            Object value = info.getPropertyValue(parentObj);
            this.setObject(value);
            Map map = null;
            if (value instanceof Map) {
                map = (Map)value;
            } else if (value instanceof DynamicPropertySet) {
                map = ((DynamicPropertySet)value).getProperties();
            }
            if (map != null) {
                Map knownInfos;
                Set keys;
                Set<Object> ignoreTheseProps;
                DBObjectProvider pro = this.getProvider();
                ExplorerModelHelper helper = this.getHelper();
                PropertyManager mgr = pro.getPropertyManager();
                Class<?> parentObjClz = ((DBObject)parentObj).getClass();
                if ("properties".equals(info.getPropertyName())) {
                    PropertyCriteria crit = PropertyCriteria.createEmptyCriteria();
                    crit.setIncludeExtra(false);
                    ignoreTheseProps = PropertyHelper.getPropertyInfos(parentObjClz, null, (PropertyCriteria)crit).keySet();
                    if (this.useDBRunnable() == null) {
                        keys = map.keySet();
                        knownInfos = Collections.emptyMap();
                    } else {
                        keys = new HashSet();
                        keys.addAll(DBUtil.getFrozenProperties((DBObject)((DBObject)parentObj)).keySet());
                        PropertyCriteria extraOnly = new PropertyCriteria();
                        extraOnly.setIncludeBean(false);
                        knownInfos = mgr.getPropertyInfos(parentObjClz, extraOnly);
                        keys.addAll(knownInfos.keySet());
                    }
                } else {
                    keys = map.keySet();
                    ignoreTheseProps = Collections.emptySet();
                    knownInfos = Collections.emptyMap();
                }
                for (String propName : keys) {
                    DBExplorerElement elem;
                    if (ignoreTheseProps.contains(propName)) continue;
                    PropertyInfo pi = (PropertyInfo)knownInfos.get(propName);
                    if (pi == null) {
                        String folderProp = this.getProperty();
                        String propPath = "properties".equals(folderProp) ? propName : Property.createPath((String[])new String[]{folderProp, propName});
                        pi = mgr.findPropertyInfo(((DBObject)parentObj).getClass(), propPath);
                    }
                    if (pi == null || this.isIgnoredProperty(pi, pro, parentObj) || (elem = helper.findOrCreateElement(value instanceof Map ? parentObj : value, pi, pro, existing)) == null) continue;
                    retval.add(elem);
                }
            } else if (value != null) {
                DBLog.logIllegalState((String)"PropertiesFolder is only valid for Map properties");
            }
        }
        return retval;
    }

    @Override
    protected String createLabel() {
        return PropertyDisplayRegistry.getDisplayName((String)this.getPropertyName(), (DBObjectProvider)this.getProvider(), (DBObject)this.getParentDBObject());
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"folder.png");
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }
}

