/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.model.DBObjectPropertyNode;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;

public class DBObjectFolderFactory {
    public static Element createRootFolder(DBObjectNode newNode, Context context) {
        return new SimpleRoot(newNode, context);
    }

    public static void update(Element elem) {
        if (elem instanceof DBExplorerElement) {
            ((DBExplorerElement)elem).reset();
        }
    }

    public static void setErrors(final Element root, final List<Element> errors) {
        if (root instanceof BaseFolder) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((BaseFolder)root).setErrors(errors);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((BaseFolder)root).setErrors(errors);
                    }
                });
            }
        }
    }

    public static boolean canGoToDeclaration(Context context) {
        boolean retval = false;
        if (context.getView() instanceof ExplorerWindow) {
            Element elem;
            Node node = context.getNode();
            if (node instanceof BaseDBObjectTextNode) {
                return DBObjectFolderFactory.getElementWeCanGoTo(context.getElement()) != null;
            }
            if (node instanceof DBObjectNode && !DBObjectNodeUtil.isOnlineNode((Object)node) && (elem = DBObjectFolderFactory.getElementWeCanGoTo(context.getElement())) != null) {
                DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory((DBObjectNode)((DBObjectNode)node));
                retval = fac != null;
            }
        }
        return retval;
    }

    public static void handleGoToDeclaration(Context context) {
        Element elem;
        Node node = context.getNode();
        if (node instanceof DBObjectNode && (elem = DBObjectFolderFactory.getElementWeCanGoTo(context.getElement())) != null) {
            DBEditorConfig config = DBEditorConfig.newEditConfig((DBObjectNode)((DBObjectNode)node));
            DBObject child = null;
            String prop = null;
            if (elem instanceof DBObjectNode) {
                child = ((DBObjectNode)elem).getDBObject();
            } else if (elem instanceof DBObjectPropertyNode) {
                child = ((DBObjectPropertyNode)elem).getParentDBObject();
                prop = ((DBObjectPropertyNode)elem).getPropertyName();
            }
            if (child != null && child.getParent() != null) {
                config.setChildObject(child);
            }
            config.setProperty(prop);
            if (node instanceof BaseDBObjectTextNode) {
                BaseDBEditorFactory.showEditor((DBEditorConfig)config);
            } else {
                DBEditorFactory factory = DBEditorFactoryRegistry.getEditFactory((DBObjectNode)((DBObjectNode)node));
                if (factory != null) {
                    factory.launchDialog(config);
                }
            }
        }
    }

    private static Element getElementWeCanGoTo(Element elem) {
        Element retval = null;
        if (elem instanceof DBObjectNode || elem instanceof DBObjectPropertyNode) {
            retval = elem;
        } else if (elem instanceof BaseFolder) {
            retval = DBObjectFolderFactory.getElementWeCanGoTo(((BaseFolder)elem).getParentElement());
        }
        return retval;
    }

    private static class SimpleRoot
    extends BaseFolder {
        private DBObjectNode m_node;
        private Context m_context;
        private DBObjectFolder m_root;

        public SimpleRoot(DBObjectNode newNode, Context context) {
            this.m_node = newNode;
            this.m_context = context;
            this.setHelper(new ExplorerModelHelper(context));
        }

        @Override
        protected List<Element> createChildren(List<Element> existing) {
            ArrayList<Element> l = new ArrayList<Element>();
            if (this.m_root == null) {
                this.m_root = this.m_node instanceof DBObjectPlSqlNode ? new PlSqlFragmentElement(this.m_node) : new DBObjectFolder(this.m_node);
            } else {
                this.m_root.setDBObjectNode(this.m_node);
            }
            this.getHelper().setRootFolder(this.m_root);
            l.add(this.m_root);
            return l;
        }

        public String getShortLabel() {
            return "root";
        }

        @Override
        public String getLongLabel() {
            return this.m_node.getLongLabel();
        }

        public Icon getIcon() {
            return this.m_node.getIcon();
        }

        @Override
        public String getToolTipText() {
            return this.m_node.getToolTipText();
        }

        @Override
        public Object getKey() {
            return this.m_node.getURL();
        }

        @Override
        protected DBObjectProvider useDBRunnable() {
            if (this.m_root != null) {
                return this.m_root.useDBRunnable();
            }
            return super.useDBRunnable();
        }
    }
}

