/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.awt.Component;
import java.util.logging.Level;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.BasePlSqlTextNode;
import oracle.ideimpl.db.explorer.ExplorerController;
import oracle.ideimpl.db.explorer.resource.ExplorerBundle;
import oracle.javatools.db.DBLog;

public class ExplorerContextMenuListener
implements ContextMenuListener {
    public boolean handleDefaultAction(Context context) {
        boolean retval = false;
        if (ExplorerController.isEnabled(context)) {
            try {
                ExplorerController.getAction().performAction(context);
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error in Go to Source for pl/sql", e);
            }
            retval = true;
        }
        return retval;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (ExplorerController.isEnabled(context)) {
            JMenuItem item = contextMenu.createMenuItem((ToggleAction)ExplorerController.getAction());
            if (context.getNode() instanceof BasePlSqlTextNode) {
                String txt = ExplorerBundle.get("EXPLORER_GOTO_SOURCE");
                item.setText(StringUtils.stripMnemonic((String)txt));
                item.setMnemonic(StringUtils.getMnemonicKeyCode((String)txt));
            }
            contextMenu.add((Component)item);
        }
    }
}

