/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.ExtensibleGroup;
import oracle.ide.util.NameValuePair;
import oracle.ideimpl.inspector.PIHook;
import oracle.ideimpl.inspector.layout.DefaultElementFactory;
import oracle.javatools.data.HashStructure;

public class DefaultExtensibleGroup
extends ExtensibleGroup {
    private final String _elementName;
    private final HashStructure _hash;
    private ClassLoader _classLoader = null;
    private ExtensibleGroup _base;
    private List<Element> _children;

    DefaultExtensibleGroup(String elementName, HashStructure hash) {
        this._elementName = elementName;
        this._hash = hash;
    }

    DefaultExtensibleGroup(String elementName, HashStructure hash, ClassLoader classLoader) {
        this(elementName, hash);
        this._classLoader = classLoader;
    }

    protected ExtensibleGroup createBase() {
        HashStructure hash = PIHook.getPIHook().getExtensibleElement(this.getExtends(), this._elementName);
        if (hash != null) {
            return (ExtensibleGroup)DefaultElementFactory.createElement(this._elementName, hash, this._classLoader);
        }
        return null;
    }

    protected HashStructure getHash() {
        return this._hash;
    }

    @Override
    public String getTitle() {
        if (this._hash.containsKey("title")) {
            return this._hash.getString("title");
        }
        if (this.getBase() != null) {
            return this.getBase().getTitle();
        }
        return null;
    }

    @Override
    public String getHint() {
        if (this._hash.containsKey("hint")) {
            return this._hash.getString("hint");
        }
        if (this.getBase() != null) {
            return this.getBase().getHint();
        }
        return null;
    }

    @Override
    public boolean isExpanded() {
        if (this._hash.containsKey("expanded")) {
            return this._hash.getBoolean("expanded");
        }
        if (this.getBase() != null) {
            return this.getBase().isExpanded();
        }
        return true;
    }

    public String getID() {
        return this._hash.getString("id");
    }

    @Override
    public String getExtends() {
        return this._hash.getString("extends");
    }

    @Override
    public ExtensibleGroup getBase() {
        if (this._base == null) {
            this._base = this.createBase();
        }
        return this._base;
    }

    @Override
    public String getPartOf() {
        return this._hash.getString("part-of");
    }

    @Override
    public List<Element> getChildren() {
        if (this._children != null) {
            return this._children;
        }
        this._children = new ArrayList<Element>();
        ExtensibleGroup base = this.getBase();
        if (base != null) {
            this._children.addAll(base.getChildren());
        }
        Collection structures = PIHook.getPIHook().getOrderedElements(this.getHash());
        for (NameValuePair pair : structures) {
            Element child = DefaultElementFactory.createElement(pair.getName(), (HashStructure)pair.getValue(), this._classLoader);
            if (child == null) continue;
            this._children.add(child);
        }
        return this._children;
    }
}

