/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.SAXManifestParser;
import javax.ide.util.MetaClass;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureElementVisitor;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.FormLayoutFactory;
import oracle.ide.inspector.layout.PropertyFormLayout;
import oracle.ide.inspector.layout.PropertyFormLayoutAssembly;
import oracle.ide.util.Assert;
import oracle.ideimpl.inspector.layout.DefaultPropertyFormLayout;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class PIHook
extends HashStructureHook
implements FormLayoutFactory {
    public static final String PROPERTY_FORM_LAYOUTS = "property-form-layouts";
    public static final String INSPECTABLE_FACTORIES = "inspectable-factories";
    public static final String INSPECTABLE_FACTORY = "inspectable-factory";
    public static final String INSPECTABLE_FACTORY_CLASS = "class";
    private static final ElementName PI_HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "property-inspector-hook");
    private final ConcurrentMap<String, ConcurrentMap<String, HashStructure>> _extensibleElementsMap = new ConcurrentHashMap<String, ConcurrentMap<String, HashStructure>>();
    private final ConcurrentMap<String, List<PropertyFormLayout>> _urlToLayoutMap = new ConcurrentHashMap<String, List<PropertyFormLayout>>();
    private static final List EXTENSIBLE_ELEMENTS = Arrays.asList("category-layout", "display-group", "choice", "choice-group");

    public static PIHook getPIHook() {
        return (PIHook)javax.ide.extension.ExtensionRegistry.getExtensionRegistry().getHook(PI_HOOK_NAME);
    }

    public PIHook() {
        super(true);
    }

    @Override
    public PropertyFormLayout createPropertyFormLayout(PropertyModel propertyModel) {
        List<HashStructure> layouts = this.getPropertyFormLayoutList(this.getHashStructure());
        ArrayList<Element> layoutsToReturn = new ArrayList<Element>();
        for (HashStructure layout : layouts) {
            String pmClass = layout.getString("property-model-class");
            if (pmClass == null || !pmClass.equals(propertyModel.getClass().getName())) continue;
            layoutsToReturn.add(new DefaultPropertyFormLayout(layout));
        }
        if (layoutsToReturn.isEmpty()) {
            return null;
        }
        if (layoutsToReturn.size() == 1) {
            return (PropertyFormLayout)layoutsToReturn.get(0);
        }
        return new PropertyFormLayoutAssembly(layoutsToReturn);
    }

    public List<MetaClass> getInspectableFactories() {
        List<HashStructure> providers = this.getInspectableFactoriesList();
        ArrayList<MetaClass> classes = new ArrayList<MetaClass>();
        ArrayList<String> addedClasses = new ArrayList<String>();
        for (HashStructure provider : providers) {
            List metaClasses = provider.getAsList(INSPECTABLE_FACTORY);
            if (metaClasses == null) continue;
            for (int i = 0; i < metaClasses.size(); ++i) {
                HashStructure hash = (HashStructure)metaClasses.get(i);
                MetaClass mclass = LazyClassAdapter.getInstance((HashStructure)hash).getMetaClass(INSPECTABLE_FACTORY_CLASS);
                if (mclass == null) continue;
                String metaClassName = mclass.getClassName();
                if (addedClasses.contains(metaClassName)) {
                    Assert.println((String)("Warning: Duplicate inspectable '" + metaClassName + "' registered in PIHook. Using only the first one found."));
                    continue;
                }
                classes.add(mclass);
                addedClasses.add(metaClassName);
            }
        }
        return classes;
    }

    public HashStructure getExtensibleElement(String id, String elementName) {
        Map map;
        if (ModelUtil.hasLength((String)id) && ModelUtil.hasLength((String)elementName) && (map = (Map)this.getExtensibleElementsMap().get(elementName)) != null) {
            return (HashStructure)map.get(id);
        }
        return null;
    }

    public HashStructure processExternalInspectorHook(String url, String extensionID, String rsBundleClassName) {
        return this.processExternalInspectorHook(null, url, extensionID, rsBundleClassName, null);
    }

    public HashStructure processExternalInspectorHook(XMLReader reader, String url, String extensionID, String rsBundleClassName, ClassLoader classLoader) {
        DefaultElementContext context = new DefaultElementContext();
        Map map = context.getScopeData();
        Extension extension = ExtensionRegistry.getExtensionRegistry().findExtension(extensionID);
        if (extension == null) {
            return null;
        }
        map.put("extension", extension);
        if (rsBundleClassName != null) {
            map.put("rsbundleclass", rsBundleClassName);
        }
        if (classLoader != null) {
            map.put("classLoader", classLoader);
        }
        ExtensionSource src = ((DefaultExtension)extension).getSource();
        map.put("extSource", src);
        HashStructureElementVisitor visitor = new HashStructureElementVisitor();
        visitor.turnElementCounterOn();
        context.registerChildVisitor(PI_HOOK_NAME, (ElementVisitor)visitor);
        SAXManifestParser parser = new SAXManifestParser(context);
        try {
            InputSource source = new InputSource(url);
            if (reader != null) {
                parser.parse(reader, source);
            } else {
                parser.parse(source);
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        return visitor.getHashStructure();
    }

    public List<PropertyFormLayout> getExternalPropertyFormLayouts(String url, String extensionID, String rsBundleClassName, ClassLoader classLoader) {
        return this.getExternalPropertyFormLayouts(null, url, extensionID, rsBundleClassName, classLoader);
    }

    public List<PropertyFormLayout> getExternalPropertyFormLayouts(XMLReader reader, String url, String extensionID, String rsBundleClassName, ClassLoader classLoader) {
        if (!this._urlToLayoutMap.containsKey(url)) {
            HashStructure hash = this.processExternalInspectorHook(reader, url, extensionID, rsBundleClassName, classLoader);
            List<HashStructure> pfls = this.getPropertyFormLayoutList(hash);
            ArrayList<DefaultPropertyFormLayout> result = new ArrayList<DefaultPropertyFormLayout>(pfls.size());
            Iterator<HashStructure> i = pfls.iterator();
            while (i.hasNext()) {
                result.add(new DefaultPropertyFormLayout(i.next(), classLoader));
            }
            this._urlToLayoutMap.put(url, result);
        }
        return (List)this._urlToLayoutMap.get(url);
    }

    private List<HashStructure> getInspectableFactoriesList() {
        ArrayList<HashStructure> list = new ArrayList<HashStructure>();
        HashStructure pi = this.getHashStructure();
        List factories = pi.getAsList(INSPECTABLE_FACTORIES);
        if (factories != null) {
            list.addAll(factories);
        }
        return list;
    }

    private List<HashStructure> getPropertyFormLayoutsList(HashStructure hash) {
        ArrayList<HashStructure> list = new ArrayList<HashStructure>();
        List layouts = hash.getAsList(PROPERTY_FORM_LAYOUTS);
        if (layouts != null) {
            list.addAll(layouts);
        }
        return list;
    }

    private List<HashStructure> getPropertyFormLayoutList(HashStructure hash) {
        ArrayList<HashStructure> list = new ArrayList<HashStructure>();
        List<HashStructure> layoutsList = this.getPropertyFormLayoutsList(hash);
        for (HashStructure hs : layoutsList) {
            List pflList = hs.getAsList("property-form-layout");
            if (pflList == null) continue;
            list.addAll(pflList);
        }
        return list;
    }

    private Map<String, ConcurrentMap<String, HashStructure>> getExtensibleElementsMap() {
        List<HashStructure> pfls = this.getPropertyFormLayoutsList(this.getHashStructure());
        for (HashStructure hs : pfls) {
            try {
                this.mapExtensibleElements(hs);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        return this._extensibleElementsMap;
    }

    private void mapExtensibleElements(HashStructure hash) {
        Iterator iterator = hash.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            this.mapExtensibleElements(hash, key);
        }
    }

    private void mapExtensibleElements(HashStructure hash, String key) {
        Object value = hash.getObject(key);
        if (value instanceof HashStructure) {
            HashStructure hs = (HashStructure)value;
            this.mapExtensibleElement(hs, hs.getStructName());
            this.mapExtensibleElements(hs);
        } else if (value instanceof ListStructure) {
            ListStructure list = (ListStructure)value;
            Iterator iterator = list.iterator();
            String name = list.getStructName();
            while (iterator.hasNext()) {
                HashStructure hs = (HashStructure)iterator.next();
                this.mapExtensibleElement(hs, name);
                this.mapExtensibleElements(hs);
            }
        }
    }

    private void mapExtensibleElement(HashStructure hash, String name) {
        HashStructure previous;
        String id = hash.getString("id", "");
        if (id.length() == 0 || !EXTENSIBLE_ELEMENTS.contains(name)) {
            return;
        }
        if (!ModelUtil.hasLength((String)name)) {
            return;
        }
        ConcurrentHashMap<String, HashStructure> newMap = new ConcurrentHashMap<String, HashStructure>();
        ConcurrentHashMap<String, HashStructure> map = this._extensibleElementsMap.putIfAbsent(id, newMap);
        if (map == null) {
            map = newMap;
        }
        if ((previous = map.putIfAbsent(id, hash)) != null) {
            this.reportDuplicateID(id, hash, previous, name);
        }
    }

    private void reportDuplicateID(String ID, HashStructure newHS, HashStructure originalHS, String name) {
        Assert.println((String)String.format("Warning: The extension %s defines a duplicate %s\n ID: %s.\nExtension %s defined that ID previously.\n", newHS.getString("#__extension-id"), name, ID, originalHS.getString("#__extension-id")));
    }
}

