/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.util.PropertyAccess;

final class AutoExpandPreferredSizes {
    private final Map<Integer, AutoExpandPreferredSize> sizes = new LinkedHashMap<Integer, AutoExpandPreferredSize>();

    AutoExpandPreferredSizes() {
        this.sizes.put(0, new AutoExpandPreferredSize("west."));
        this.sizes.put(1, new AutoExpandPreferredSize("east."));
        this.sizes.put(2, new AutoExpandPreferredSize("north."));
        this.sizes.put(3, new AutoExpandPreferredSize("south."));
    }

    void put(int orientation, String key, Dimension size) {
        this.sizes.get(orientation).put(key, size);
    }

    void loadFrom(PropertyAccess properties, String viewId) {
        for (Map.Entry<Integer, AutoExpandPreferredSize> entry : this.sizes.entrySet()) {
            entry.getValue().loadFrom(properties, viewId);
        }
    }

    void saveTo(PropertyAccess properties, String viewId) {
        for (Map.Entry<Integer, AutoExpandPreferredSize> entry : this.sizes.entrySet()) {
            entry.getValue().saveTo(properties, viewId);
        }
    }

    void updateSizeKey(String currentKey, String newKey) {
        for (Map.Entry<Integer, AutoExpandPreferredSize> entry : this.sizes.entrySet()) {
            entry.getValue().updateSizeKey(currentKey, newKey);
        }
    }

    void clear() {
        for (Map.Entry<Integer, AutoExpandPreferredSize> entry : this.sizes.entrySet()) {
            entry.getValue().clear();
        }
    }

    Dimension size(String key, int orientation) {
        AutoExpandPreferredSize size = this.sizes.get(orientation);
        return size.size(key);
    }

    private static class AutoExpandPreferredSize {
        final Map<String, Dimension> sizeMap = new LinkedHashMap<String, Dimension>();
        final String orientation;
        private static final String AUTO_EXPAND_SIZE_COUNT = ".autoExpandSizeCount.";
        private static final String AUTO_EXPAND_KEY = ".autoExpandKey.";
        private static final String AUTO_EXPAND_WIDTH = ".autoExpandWidth.";
        private static final String AUTO_EXPAND_HEIGHT = ".autoExpandHeight.";

        AutoExpandPreferredSize(String orientation) {
            this.orientation = orientation;
        }

        final void clear() {
            this.sizeMap.clear();
        }

        final void put(String key, Dimension d) {
            this.sizeMap.put(key, d);
        }

        final Dimension size(String key) {
            if (this.sizeMap.containsKey(key)) {
                return this.sizeMap.get(key);
            }
            return null;
        }

        final void updateSizeKey(String currentKey, String newKey) {
            if (!this.sizeMap.containsKey(currentKey)) {
                return;
            }
            Dimension d = this.sizeMap.get(currentKey);
            this.sizeMap.remove(currentKey);
            this.sizeMap.put(newKey, d);
        }

        final void loadFrom(PropertyAccess properties, String viewId) {
            Map<String, String> propertyNames = this.propertyNames(viewId);
            this.sizeMap.clear();
            int count = this.intProperty(properties, propertyNames.get(AUTO_EXPAND_SIZE_COUNT), 0);
            if (count == 0) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                int height;
                int width;
                String key = properties.getProperty(propertyNames.get(AUTO_EXPAND_KEY) + i, null);
                if (key == null || (width = this.intProperty(properties, propertyNames.get(AUTO_EXPAND_WIDTH) + i, -1)) == -1 || (height = this.intProperty(properties, propertyNames.get(AUTO_EXPAND_HEIGHT) + i, -1)) == -1) continue;
                this.sizeMap.put(key, new Dimension(width, height));
            }
        }

        final void saveTo(PropertyAccess properties, String viewId) {
            this.removeAutoExpandSizes(properties, viewId);
            this.saveAutoExpandSizes(properties, viewId);
        }

        private void removeAutoExpandSizes(PropertyAccess properties, String viewId) {
            Map<String, String> propertyNames = this.propertyNames(viewId);
            int count = this.intProperty(properties, propertyNames.get(AUTO_EXPAND_SIZE_COUNT), 0);
            properties.removeProperty(propertyNames.get(AUTO_EXPAND_SIZE_COUNT));
            if (count == 0) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                properties.removeProperty(propertyNames.get(AUTO_EXPAND_KEY) + i);
                properties.removeProperty(propertyNames.get(AUTO_EXPAND_WIDTH) + i);
                properties.removeProperty(propertyNames.get(AUTO_EXPAND_HEIGHT) + i);
            }
        }

        private void saveAutoExpandSizes(PropertyAccess properties, String viewId) {
            Map<String, String> propertyNames = this.propertyNames(viewId);
            int size = this.sizeMap.size();
            properties.setProperty(propertyNames.get(AUTO_EXPAND_SIZE_COUNT), String.valueOf(size));
            if (size == 0) {
                return;
            }
            int i = 0;
            for (Map.Entry<String, Dimension> entry : this.sizeMap.entrySet()) {
                Dimension d = entry.getValue();
                if (d == null) continue;
                properties.setProperty(propertyNames.get(AUTO_EXPAND_KEY) + i, entry.getKey());
                this.saveIntProperty(properties, propertyNames.get(AUTO_EXPAND_WIDTH) + i, d.width);
                this.saveIntProperty(properties, propertyNames.get(AUTO_EXPAND_HEIGHT) + i, d.height);
                ++i;
            }
        }

        private Map<String, String> propertyNames(String viewId) {
            LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
            names.put(AUTO_EXPAND_SIZE_COUNT, this.realPropertyName(viewId, AUTO_EXPAND_SIZE_COUNT));
            names.put(AUTO_EXPAND_KEY, this.realPropertyName(viewId, AUTO_EXPAND_KEY));
            names.put(AUTO_EXPAND_WIDTH, this.realPropertyName(viewId, AUTO_EXPAND_WIDTH));
            names.put(AUTO_EXPAND_HEIGHT, this.realPropertyName(viewId, AUTO_EXPAND_HEIGHT));
            return names;
        }

        private String realPropertyName(String viewId, String propertyName) {
            return viewId + propertyName + this.orientation;
        }

        private int intProperty(PropertyAccess properties, String propertyId, int defaultValue) {
            String propertyValue = properties.getProperty(propertyId, String.valueOf(defaultValue));
            try {
                return Integer.valueOf(propertyValue);
            }
            catch (NumberFormatException ignored) {
                return defaultValue;
            }
        }

        private void saveIntProperty(PropertyAccess properties, String propertyId, int value) {
            properties.setProperty(propertyId, String.valueOf(value));
        }
    }
}

