/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

final class Turner
extends JComponent {
    private boolean _isExpanded;

    public Turner() {
        this.setBackground(UIManager.getColor("Tree.background"));
        this.addMouseListener(new EventHandler(this));
        this.setFocusable(true);
    }

    public void setExpanded(boolean isExpanded) {
        if (isExpanded == this._isExpanded) {
            return;
        }
        this._isExpanded = isExpanded;
        this.repaint();
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon = this.getIcon();
        Insets insets = this.getInsets();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        return new Dimension(w + insets.left + insets.right, h + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Icon icon = this.getIcon();
        Insets insets = this.getInsets();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int width = this.getWidth();
        int height = this.getHeight();
        icon.paintIcon(this, g, insets.left + (width - w) / 2, insets.top + (height - h) / 2);
    }

    protected Icon getIcon() {
        return UIManager.getIcon(this._isExpanded ? "Tree.expandedIcon" : "Tree.collapsedIcon");
    }

    private static class EventHandler
    implements MouseListener {
        private final Turner _turner;

        public EventHandler(Turner turner) {
            this._turner = turner;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._turner.setExpanded(!this._turner.isExpanded());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

