/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.inspector.ChoiceGroupPanel;
import oracle.ide.inspector.DisplayGroupAwareContainerSearch;
import oracle.ide.inspector.DisplayGroupPanel;
import oracle.ide.inspector.DisplayGroupPanelFactory;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyCategoryPanel;
import oracle.ide.inspector.RenderInfo;
import oracle.ide.inspector.RenderingUtils;
import oracle.ide.inspector.ScrollablePanelDelegate;
import oracle.ide.inspector.find.ContainerSearch;
import oracle.ide.inspector.layout.CategoryLayout;
import oracle.ide.inspector.layout.ChoiceGroup;
import oracle.ide.inspector.layout.DisplayGroup;
import oracle.ide.inspector.layout.Element;

final class PropertyCategoryLayoutPanel
extends JPanel
implements PropertyCategoryPanel {
    private static final Color HINT_FOREGROUND = new Color(102, 102, 102);
    private CategoryLayout layout;
    private boolean rendered;
    private ContainerSearch containerSearch;
    private ScrollablePanelDelegate scrollablePanelDelegate = new ScrollablePanelDelegate(this);

    PropertyCategoryLayoutPanel(CategoryLayout layout) {
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.layout = layout;
    }

    @Override
    public boolean findText(String searchText, boolean searchForward, boolean searchRepeat) {
        if (this.containerSearch == null) {
            this.containerSearch = new DisplayGroupAwareContainerSearch(this);
        }
        return this.containerSearch.findText(searchText, searchForward, searchRepeat);
    }

    @Override
    public boolean isRendered() {
        return this.rendered;
    }

    @Override
    public void render(Properties properties, Orientation orientation) {
        if (properties == null || this.layout == null) {
            return;
        }
        this.removeAll();
        GridBagConstraints c = RenderingUtils.initialConstraints();
        this.populateRows(properties, new RenderInfo(c, this), orientation);
        if (Orientation.HORIZONTAL.equals((Object)orientation)) {
            RenderingUtils.addVerticalGlueTo(this, c);
        }
        this.rendered = true;
    }

    private void populateRows(Properties properties, RenderInfo renderingInfo, Orientation orientation) {
        this.renderHint(renderingInfo);
        for (Element child : this.layout.getChildren()) {
            if (!this.displayGroupRendered(child, properties, renderingInfo, orientation) && !this.choiceGroupRendered(child, properties, renderingInfo, orientation)) continue;
        }
    }

    private void renderHint(RenderInfo renderingInfo) {
        String categoryHint = this.layout.getHint();
        if (categoryHint == null || categoryHint.length() == 0) {
            return;
        }
        JLabel categoryHintLabel = new JLabel(categoryHint);
        categoryHintLabel.setFont(categoryHintLabel.getFont().deriveFont(1));
        categoryHintLabel.setForeground(HINT_FOREGROUND);
        renderingInfo.constraints().anchor = 17;
        renderingInfo.parent().add((Component)categoryHintLabel, renderingInfo.constraints());
        ++renderingInfo.constraints().gridy;
        renderingInfo.parent().add(Box.createVerticalStrut(20), renderingInfo.constraints());
        ++renderingInfo.constraints().gridy;
    }

    private boolean displayGroupRendered(Element target, Properties properties, RenderInfo renderingInfo, Orientation orientation) {
        if (!(target instanceof DisplayGroup)) {
            return false;
        }
        DisplayGroup group = (DisplayGroup)target;
        this.renderDisplayGroup(group, properties, renderingInfo, orientation);
        return true;
    }

    private void renderDisplayGroup(DisplayGroup group, Properties properties, RenderInfo renderingInfo, Orientation orientation) {
        if (group.getChildren() == null || group.getChildren().isEmpty()) {
            return;
        }
        DisplayGroupPanel displayGroupPanel = DisplayGroupPanelFactory.createDisplayGroupPanel(group, properties, orientation);
        if (!displayGroupPanel.hasContent()) {
            return;
        }
        displayGroupPanel.setBackground(this.getBackground());
        renderingInfo.parent().add((Component)displayGroupPanel, renderingInfo.constraints());
        ++renderingInfo.constraints().gridy;
    }

    private boolean choiceGroupRendered(Element e, Properties properties, RenderInfo renderingInfo, Orientation orientation) {
        if (!(e instanceof ChoiceGroup)) {
            return false;
        }
        ChoiceGroup choiceGroup = (ChoiceGroup)e;
        ChoiceGroupPanel choiceGroupPanel = new ChoiceGroupPanel(choiceGroup, properties, orientation);
        if (!choiceGroupPanel.hasContent()) {
            return true;
        }
        choiceGroupPanel.setBackground(this.getBackground());
        renderingInfo.update(renderingInfo.copyConstraints());
        renderingInfo.constraints().gridwidth = 2;
        renderingInfo.constraints().weightx = 1.0;
        renderingInfo.parent().add((Component)choiceGroupPanel, renderingInfo.constraints());
        renderingInfo.restore();
        ++renderingInfo.constraints().gridy;
        return true;
    }

    @Override
    public JComponent categoryPanel() {
        return this;
    }

    @Override
    public String categoryTitle() {
        return this.layout.getTitle();
    }

    @Override
    public boolean isDefaultSelected() {
        return this.layout.isSelected() != null ? this.layout.isSelected() : false;
    }

    @Override
    public boolean isDefaultExpanded() {
        return this.layout.isExpanded() != null ? this.layout.isExpanded() : false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.scrollablePanelDelegate.preferredScrollableViewportSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.scrollablePanelDelegate.scrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.scrollablePanelDelegate.scrollableBlockIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.scrollablePanelDelegate.scrollableTracksViewportWidth();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.scrollablePanelDelegate.scrollableTracksViewportHeight();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.scrollablePanelDelegate.paintComponent(g);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        for (Component c : this.getComponents()) {
            if (!(c instanceof DisplayGroupPanel) && !(c instanceof ChoiceGroupPanel)) continue;
            c.setBackground(bg);
        }
    }
}

