/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextField;
import oracle.bali.inspector.PropertyEditorFactory2;

final class PaintablePropertyEditor
extends JComponent {
    private final JTextField _field;

    public PaintablePropertyEditor(PropertyEditorFactory2 editorFactory, boolean writable) {
        this._field = new PaintableField(editorFactory, writable);
        this.setLayout(new BorderLayout());
        this.add((Component)this._field, "Center");
    }

    private static final class PaintableField
    extends JTextField {
        private final PropertyEditorFactory2 editorFactory;

        public PaintableField(PropertyEditorFactory2 editorFactory, boolean writable) {
            assert (editorFactory != null && editorFactory.isPaintable());
            this.editorFactory = editorFactory;
            this.setFocusable(false);
            this.setEditable(writable);
            this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Insets insets = this.getInsets();
            Rectangle box = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            this.editorFactory.paintValue(g, box);
        }
    }
}

