/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.util.HashMap;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.panels.NavigableUIContainer;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.data.PropertyStorage;

public final class TraversableContext
extends Namespace {
    public static final int RANDOM_ACCESS_TRAVERSAL = 0;
    public static final int FORWARD_TRAVERSAL = 1;
    public static final int BACKWARD_TRAVERSAL = 2;
    public static final int FOCUS_TRAVERSAL = 3;
    private final MetaTraversable _metaTraversable;
    private int _direction;
    private HashMap _dtObjects;
    private TraversableContext _dtParent;
    private static final String WizardCallbacks_DT_NAME = "wizard-callbacks";
    private static final String DialogCallbacks_DT_NAME = "dialog-callbacks";

    public TraversableContext(Navigable navigable, int direction) {
        this((MetaTraversable)navigable, navigable.getDataScope(), direction);
    }

    public TraversableContext(Namespace namespace, int direction) {
        this(null, namespace, direction);
    }

    TraversableContext(MetaTraversable metaTraversable, TraversableContext parent, int direction) {
        this(metaTraversable, (Namespace)parent, direction);
        this._dtParent = parent;
    }

    TraversableContext(MetaTraversable metaTraversable, Namespace namespace, int direction) {
        super(namespace, false);
        if (direction < 0 || direction > 3) {
            throw new IllegalArgumentException();
        }
        this._metaTraversable = metaTraversable;
        this._direction = direction;
    }

    public int getDirection() {
        return this._direction;
    }

    public void setDirection(int direction) {
        if (direction < 0 || direction > 3) {
            throw new IllegalArgumentException();
        }
        this._direction = direction;
    }

    public WizardCallbacks getWizardCallbacks() {
        return (WizardCallbacks)this.getDesignTimeObject(WizardCallbacks_DT_NAME);
    }

    public void setWizardCallbacks(WizardCallbacks callbacks) {
        this.putDesignTimeObject(WizardCallbacks_DT_NAME, callbacks);
    }

    public DialogCallbacks getDialogCallbacks() {
        return (DialogCallbacks)this.getDesignTimeObject(DialogCallbacks_DT_NAME);
    }

    public void setDialogCallbacks(DialogCallbacks callbacks) {
        this.putDesignTimeObject(DialogCallbacks_DT_NAME, callbacks);
    }

    public PropertyStorage getPropertyStorage() {
        return (PropertyStorage)this.get("generic-PropertyStorage");
    }

    public Object getDesignTimeObject(String key) {
        Namespace ns = this;
        while (true) {
            TraversableContext tc = null;
            if (ns instanceof TraversableContext) {
                Object obj;
                tc = ns;
                if (tc._dtObjects != null && (obj = tc._dtObjects.get(key)) != null) {
                    return obj;
                }
            }
            if (ns.isRoot()) break;
            if (tc != null && tc._dtParent != null) {
                ns = tc._dtParent;
                continue;
            }
            ns = ns.getParent();
        }
        return null;
    }

    public void putDesignTimeObject(String key, Object dtObject) {
        if (this._dtObjects == null) {
            this._dtObjects = new HashMap(11);
        }
        this._dtObjects.put(key, dtObject);
    }

    public NavigableContext newNavigableContext() {
        NavigableUIContainer uiContainer = (NavigableUIContainer)this.getDesignTimeObject("navigable-ui-container");
        return new NavigableContext(this, uiContainer != null && uiContainer.displayDetailNodesAsChildren());
    }

    @Override
    protected String translateKey(String key) {
        return this._metaTraversable != null ? this._metaTraversable.getNameLink(key) : key;
    }

    void setDesignTimeParent(TraversableContext tc) {
        this._dtParent = tc;
    }
}

