/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.lang.reflect.Constructor;
import oracle.ide.panels.Traversable;
import oracle.javatools.util.Copyable;

final class MetaCtor
implements Copyable {
    private String _classStr;
    private Class _class;
    private Class[] _ctorArgTypes;

    MetaCtor(String classStr, Class[] ctorArgTypes) {
        this._classStr = classStr;
        this._ctorArgTypes = ctorArgTypes;
    }

    MetaCtor(Class clazz, Class[] ctorArgTypes) {
        this._class = clazz;
        this._ctorArgTypes = ctorArgTypes;
    }

    private MetaCtor() {
    }

    public Object copyTo(Object target) {
        MetaCtor copy = target != null ? (MetaCtor)target : new MetaCtor();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(MetaCtor copy) {
        copy._classStr = this._classStr;
        copy._class = this._class;
        copy._ctorArgTypes = this._ctorArgTypes;
    }

    Class getDeclaringClass() {
        try {
            this.maybeInitClass();
            return this._class;
        }
        catch (Exception e) {
            return null;
        }
    }

    Constructor getConstructor() throws ClassNotFoundException, NoSuchMethodException {
        this.maybeInitClass();
        MetaCtor.validateClass(this._class);
        Constructor ctor = this._class.getDeclaredConstructor(this._ctorArgTypes);
        ctor.setAccessible(true);
        return ctor;
    }

    private void maybeInitClass() throws ClassNotFoundException, NoSuchMethodException {
        if (this._class == null) {
            this._class = Class.forName(this._classStr);
            this._classStr = null;
        }
    }

    private static void validateClass(Class traversableClass) {
        if (traversableClass == null) {
            throw new IllegalArgumentException("Unexpected null Traversable class.");
        }
        if (!Traversable.class.isAssignableFrom(traversableClass)) {
            throw new IllegalArgumentException("The specified class does not implement the Traversable interface: " + traversableClass.getName());
        }
    }
}

