/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import oracle.ide.marshal.xml.StructureIO;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.Structure;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class HashStructureIO
extends StructureIO {
    public HashStructureIO(String nsURI, String rootQname) {
        super(nsURI, rootQname);
    }

    public Object load(URL url) throws IOException {
        HashStructure rootHash = HashStructure.newInstance();
        this.loadImpl(url, rootHash, null);
        return rootHash;
    }

    public Object load(URL url, String[] partials) throws IOException {
        HashStructure rootHash = HashStructure.newInstance();
        this.loadImpl(url, rootHash, null, partials);
        return rootHash;
    }

    public boolean open(URL url, Object obj) throws IOException {
        if (obj == null || obj instanceof HashStructure) {
            this.loadImpl(url, (HashStructure)obj, null);
            return true;
        }
        new IllegalArgumentException("HashStructureIO cannot load an object of type " + obj.getClass().getName()).printStackTrace();
        return false;
    }

    public boolean save(URL url, Object obj) throws IOException {
        if (obj == null || obj instanceof HashStructure) {
            this.saveImpl(url, (HashStructure)obj, null);
            return true;
        }
        new IllegalArgumentException("HashStructureIO cannot save an object of type " + obj.getClass().getName()).printStackTrace();
        return false;
    }

    public HashStructure read(Reader reader, URL baseUrl) throws IOException {
        this.setDocumentURL(baseUrl);
        HashStructure hs = HashStructure.newInstance();
        BufferedReader br = null;
        try {
            br = new BufferedReader(reader);
            this.parseWithSAX(null, (Structure)hs, new InputSource(br));
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return hs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HashStructure hs, Writer writer, URL baseUrl) throws IOException {
        if (hs == null) {
            throw new NullPointerException("hs is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        XMLDocument doc = this.createDom(baseUrl, hs, null);
        try (BufferedWriter w = null;){
            w = new BufferedWriter(writer);
            doc.print((Writer)w);
        }
    }

    public HashStructure toHashStructure(Element elem) {
        HashStructure hash = HashStructure.newInstance();
        this.elem2HashStructure(elem, hash);
        return hash;
    }
}

