/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.marshal.xml.Map2Dom;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

class HashMapProxy
extends HashMap {
    private boolean _unmarshalled = false;
    private Object2Dom _o2d;
    private XMLDocument _fragmentFactory;

    HashMapProxy(Object2Dom o2d) {
        this._o2d = o2d;
    }

    @Override
    public boolean containsValue(Object value) {
        this.finishUnmarshalling();
        return super.containsValue(value);
    }

    @Override
    public Set entrySet() {
        this.finishUnmarshalling();
        return super.entrySet();
    }

    @Override
    public Object get(Object key) {
        Object value = this.superGet(key);
        if (value instanceof XMLElement && this._o2d != null) {
            Object valueObj = Map2Dom.toObject(this._o2d, (Element)((XMLElement)value));
            this.put(key, valueObj);
            return valueObj;
        }
        return value;
    }

    @Override
    public Collection values() {
        this.finishUnmarshalling();
        return super.values();
    }

    Object superGet(Object key) {
        return super.get(key);
    }

    void narrowFragments() {
        Set keySet = this.keySet();
        if (keySet != null) {
            for (Object key : keySet) {
                Object value = this.superGet(key);
                if (!(value instanceof XMLElement)) continue;
                this.put(key, this.extractFragment((XMLElement)value));
            }
        }
    }

    private DocumentFragment extractFragment(XMLElement elem) {
        if (this._fragmentFactory == null) {
            this._fragmentFactory = new XMLDocument();
        }
        DocumentFragment frag = this._fragmentFactory.createDocumentFragment();
        frag.appendChild(elem.cloneNode(true));
        return frag;
    }

    private void finishUnmarshalling() {
        if (!this._unmarshalled) {
            Set keySet = this.keySet();
            if (keySet != null) {
                Iterator iter = keySet.iterator();
                while (iter.hasNext()) {
                    this.get(iter.next());
                }
            }
            this._o2d = null;
            this._unmarshalled = true;
        }
    }
}

