/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import java.text.Collator;
import javax.swing.Icon;
import oracle.ide.util.TriStateBoolean;

public class JTreeCellData
implements Comparable {
    protected String _text;
    protected boolean _isTextEnabled;
    protected boolean _isTextSelectable;
    protected String _toolTipText;
    protected Icon _icon;
    protected boolean _useDefaultIcons;
    protected boolean _hasCheckBox;
    protected boolean _hasRadioButton;
    protected boolean _isRadioButtonEnabled;
    protected boolean _isRadioButtonSelected;
    protected TriStateBoolean _checkBoxState = TriStateBoolean.FALSE;
    protected boolean _isCheckBoxEnabled;
    protected boolean _isCheckBoxSelectable;
    protected boolean _isArmed = false;
    protected boolean _isPressed = false;
    protected Object _userObject = null;
    protected int _heightAdj;
    private boolean _internalRadioEnabled = true;
    private static final Collator COLLATOR = Collator.getInstance();

    public JTreeCellData(String text) {
        this(null, text);
    }

    public JTreeCellData(Icon icon, String text) {
        this(icon, text, false);
    }

    public JTreeCellData(Icon icon, String text, boolean hasCheckBox) {
        this(icon, text, hasCheckBox, TriStateBoolean.FALSE);
    }

    public JTreeCellData(Icon icon, String text, boolean hasCheckBox, TriStateBoolean checkBoxState) {
        if (checkBoxState == null) {
            throw new NullPointerException();
        }
        this._icon = icon;
        this._text = text;
        this._hasCheckBox = hasCheckBox;
        this._checkBoxState = checkBoxState;
        this.setEnabled(true);
    }

    public int compareTo(Object object) {
        if (!(object instanceof JTreeCellData)) {
            throw new ClassCastException("In order to sort, all tree nodes must be an instance of JMutableTreeNode.");
        }
        return this.compareTo((JTreeCellData)object);
    }

    public int compareTo(JTreeCellData otherData) {
        if (otherData == null) {
            return 1;
        }
        String otherText = otherData._text;
        if (this._text == null) {
            if (otherText == null) {
                return 0;
            }
            return -1;
        }
        if (otherText == null) {
            return 1;
        }
        return COLLATOR.compare(this._text, otherText);
    }

    public void setEnabled(boolean isEnabled) {
        this.setEnabled(isEnabled, isEnabled);
    }

    public void setEnabled(boolean isEnabled, boolean isTextSelectable) {
        this._isTextEnabled = isEnabled;
        this._isTextSelectable = isTextSelectable;
        this._isCheckBoxEnabled = isEnabled;
        this._isCheckBoxSelectable = isEnabled;
        this._isRadioButtonEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this._isTextEnabled && (this._isCheckBoxEnabled || this._isRadioButtonEnabled);
    }

    public String toString() {
        return "" + this.getText();
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public boolean isTextEnabled() {
        return this._isTextEnabled;
    }

    public void setTextEnabled(boolean isTextEnabled) {
        this._isTextEnabled = isTextEnabled;
    }

    public boolean isTextSelectable() {
        return this._isTextSelectable;
    }

    public void setTextSelectable(boolean isTextSelectable) {
        this._isTextSelectable = isTextSelectable;
    }

    public String getToolTipText() {
        return this._toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this._toolTipText = toolTipText;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public boolean getUseDefaultIcons() {
        return this._useDefaultIcons;
    }

    public void setUseDefaultIcons(boolean useDefaultIcons) {
        this._useDefaultIcons = useDefaultIcons;
    }

    public boolean getHasCheckBox() {
        return this._hasCheckBox;
    }

    public void setHasCheckBox(boolean hasCheckBox) {
        this._hasCheckBox = hasCheckBox;
    }

    public boolean getHasRadioButton() {
        return this._hasRadioButton;
    }

    public void setRadioButtonEnabled(boolean enabled) {
        this._isRadioButtonEnabled = enabled;
    }

    public void setRadioButtonSelected(boolean selected) {
        this._isRadioButtonSelected = selected;
    }

    public boolean isRadioButtonEnabled() {
        return this._isRadioButtonEnabled;
    }

    public boolean isRadioButtonSelected() {
        return this._isRadioButtonSelected;
    }

    public void setHasRadioButton(boolean hasRadioButton) throws IllegalStateException {
        if (this.getHasCheckBox()) {
            throw new IllegalStateException();
        }
        this._hasRadioButton = hasRadioButton;
    }

    public TriStateBoolean getCheckBoxState() {
        return this._checkBoxState;
    }

    public void setCheckBoxState(TriStateBoolean checkBoxState) {
        this._checkBoxState = checkBoxState;
    }

    public void setCheckBoxState(boolean checkBoxState) {
        this.setCheckBoxState(checkBoxState ? TriStateBoolean.TRUE : TriStateBoolean.FALSE);
    }

    public boolean isCheckBoxEnabled() {
        return this._isCheckBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean isCheckBoxEnabled) {
        this._isCheckBoxEnabled = isCheckBoxEnabled;
    }

    public boolean isCheckBoxSelectable() {
        return this._isCheckBoxSelectable;
    }

    public void setCheckBoxSelectable(boolean isCheckBoxSelectable) {
        this._isCheckBoxSelectable = isCheckBoxSelectable;
    }

    public boolean isArmed() {
        return this._isArmed;
    }

    public void setArmed(boolean isArmed) {
        this._isArmed = isArmed;
    }

    public boolean isPressed() {
        return this._isPressed;
    }

    public void setPressed(boolean isPressed) {
        this._isPressed = isPressed;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public void setUserObject(Object userObject) {
        this._userObject = userObject;
    }

    public int getHeightAdjustment() {
        return this._heightAdj;
    }

    public void setHeightAdjustment(int heightAdj) {
        this._heightAdj = heightAdj;
    }

    boolean isInternalRadioEnabled() {
        return this._internalRadioEnabled;
    }

    void setInternalRadioEnabled(boolean enabled) {
        this._internalRadioEnabled = enabled;
    }
}

