/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.babelfish.db2;

import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.plugin.Fingerprint;
import oracle.sql.CLOB;

public class DB2SQLTranslator {
    private static final boolean ENABLE_TEMPLATE = false;
    private static final boolean DEBUG = true;
    private static Connection m_conn;
    private static final Hashtable<String, DB2SQLTranslator> m_translators;
    private final String m_profileName;
    private final boolean m_registerTemplate;
    private final ITranslationAll m_translator;
    private static boolean _isLocalTesting;
    private static String _callingSchema;
    private static final String TESTING_PROFILE_NAME = "SQLDEVPROFILETESTNAME";
    private static String _profileName;

    private static void Debug(String string) {
        System.out.println("DB2SQLTranslator: " + string);
    }

    private static DB2SQLTranslator getTranslator() throws SQLException {
        Object object;
        try {
            object = "select sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_NAME') from dual";
            PreparedStatement preparedStatement = m_conn.prepareStatement((String)object);
            preparedStatement.execute();
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new InternalError("sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_NAME') not available");
            }
            _profileName = resultSet.getString(1);
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new InternalError(sQLException.getMessage());
        }
        if (_profileName == null && _isLocalTesting) {
            _profileName = TESTING_PROFILE_NAME;
        }
        if ((object = m_translators.get(_profileName)) == null) {
            object = new DB2SQLTranslator(_profileName);
            m_translators.put(_profileName, (DB2SQLTranslator)object);
        }
        return object;
    }

    private DB2SQLTranslator(String string) throws SQLException {
        this.m_profileName = string;
        if (_isLocalTesting) {
            this.m_registerTemplate = true;
            this.m_translator = (ITranslationAll)ParserFactory.getParserNonOSGI((String)"oracle.dbtools.migration.parser.db2.Db2ParserMain");
        } else {
            String string2 = "select TRANSLATE_NEW_SQL from all_sql_translation_profiles where '\"'||owner||'\".\"'||profile_name||'\"' = ?";
            PreparedStatement preparedStatement = m_conn.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new SQLException("SQL translation profile " + string + " not found");
            }
            String string3 = resultSet.getString(1);
            resultSet.close();
            preparedStatement.close();
            this.m_registerTemplate = string3.equals("TRUE");
            this.m_translator = (ITranslationAll)ParserFactory.getParserNonOSGI((String)"oracle.dbtools.migration.parser.db2.Db2ParserMain");
        }
    }

    private static String clobToString(CLOB cLOB) throws SQLException {
        Reader reader = cLOB.getCharacterStream();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[4096];
        try {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
        return stringBuffer.toString();
    }

    private static CLOB stringToCLOB(String string) throws SQLException {
        CLOB cLOB = null;
        cLOB = _isLocalTesting ? CLOB.createTemporary((Connection)m_conn, (boolean)false, (int)10) : CLOB.createTemporary((Connection)m_conn, (boolean)false, (int)12);
        cLOB.setString(1L, string);
        return cLOB;
    }

    private String lookupTemplate(String string) throws SQLException {
        String string2 = "select translated_text from all_sql_translations where '\"'||owner||'\".\"'||profile_name||'\"' = ? and dbms_sql_translator.sql_hash(?, sql_text) = dbms_sql_translator.sql_hash(?, ?) and dbms_lob.compare(sql_text,?) = 0 and enabled = 'TRUE'";
        CLOB cLOB = DB2SQLTranslator.stringToCLOB(string);
        PreparedStatement preparedStatement = m_conn.prepareStatement(string2);
        preparedStatement.setString(1, this.m_profileName);
        preparedStatement.setString(2, this.m_profileName);
        preparedStatement.setString(3, this.m_profileName);
        preparedStatement.setClob(4, (Clob)cLOB);
        preparedStatement.setClob(5, (Clob)cLOB);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string3 = resultSet.next() ? DB2SQLTranslator.clobToString((CLOB)resultSet.getClob(1)) : null;
        resultSet.close();
        preparedStatement.close();
        DB2SQLTranslator.Debug("found " + string3 + " for " + string);
        return string3;
    }

    private void registerTemplate(String string, String string2) throws SQLException {
        DB2SQLTranslator.Debug("registering " + string2 + " for " + string);
        if (!_isLocalTesting) {
            String string3 = "begin dbms_sql_translator.register_sql_translation(?,?,?,false); end;";
            CallableStatement callableStatement = m_conn.prepareCall(string3);
            callableStatement.setString(1, this.m_profileName);
            callableStatement.setClob(2, (Clob)DB2SQLTranslator.stringToCLOB(string));
            callableStatement.setClob(3, (Clob)DB2SQLTranslator.stringToCLOB(string2));
            callableStatement.execute();
            callableStatement.close();
        }
    }

    public void translateSQL_(CLOB cLOB, CLOB[] cLOBArray) throws SQLException {
        String string;
        String string2 = DB2SQLTranslator.clobToString(cLOB);
        String string3 = null;
        String string4 = null;
        Fingerprint fingerprint = null;
        HashMap hashMap = null;
        DB2SQLTranslator.Debug("original SQL " + string2);
        try {
            fingerprint = this.m_translator.fingerprint(string2);
            string4 = fingerprint.getFingerprint();
            hashMap = fingerprint.getValues();
            DB2SQLTranslator.Debug("fingerprint " + string4);
            string3 = this.lookupTemplate(string4);
            if (string3 == null) {
                string3 = string4;
            }
            DB2SQLTranslator.Debug("template " + string3);
        }
        catch (SQLException sQLException) {
            System.out.println("original SQL: " + string2);
        }
        if (this.m_registerTemplate) {
            if (string3 != null && string4 != null) {
                this.registerTemplate(string4, string3);
            } else if (string4 != null) {
                string3 = string4;
                this.registerTemplate(string4, string3);
            }
        }
        if ((string = string3) != null && hashMap != null) {
            for (String string5 : hashMap.keySet()) {
                String string6 = (String)hashMap.get(string5);
                DB2SQLTranslator.Debug("replace " + string5 + " with " + string6);
                string = string.replaceAll(string5, string6);
            }
        }
        DB2SQLTranslator.Debug("translated SQL " + string);
        cLOBArray[0] = DB2SQLTranslator.stringToCLOB(string);
    }

    public void translateError_(int n, int[] nArray, String[] stringArray) throws SQLException {
        nArray[0] = 0;
        stringArray[0] = "00000";
    }

    public static void translateSQL(CLOB cLOB, CLOB[] cLOBArray) throws SQLException {
        DB2SQLTranslator dB2SQLTranslator = DB2SQLTranslator.getTranslator();
        dB2SQLTranslator.translateSQL_(cLOB, cLOBArray);
    }

    public static void translateSQL(CLOB cLOB, CLOB[] cLOBArray, Connection connection, String string) throws Exception {
        _isLocalTesting = true;
        m_conn = connection;
        _callingSchema = string;
        DB2SQLTranslator.translateSQL(cLOB, cLOBArray);
    }

    public static void translateError(int n, int[] nArray, String[] stringArray) throws SQLException {
        DB2SQLTranslator dB2SQLTranslator = DB2SQLTranslator.getTranslator();
        dB2SQLTranslator.translateError_(n, nArray, stringArray);
    }

    static {
        m_translators = new Hashtable();
        _isLocalTesting = false;
        _callingSchema = null;
        try {
            m_conn = DriverManager.getConnection("jdbc:default:connection");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

