/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLink;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

public abstract class ViewBuilderLinkPainter
extends AbstractPainter {
    public static final String PROPERTY_INVALID = "invalid";
    private PropertyChangeSupport _support;
    private boolean _valid;
    private ViewBuilderLink _link;
    private PropertyChangeListener _listener;

    public ViewBuilderLinkPainter(ViewBuilderLink link) {
        if (link == null) {
            throw new IllegalArgumentException();
        }
        this._link = link;
        this._addPropertyChangeListener();
    }

    public abstract void paint(PaintContext var1, Graphics var2, int var3, int var4, int var5, int var6);

    public abstract boolean contains(PaintContext var1, int var2, int var3);

    public abstract Rectangle getBounds(PaintContext var1);

    public abstract Dimension getMinimumSize(PaintContext var1);

    public ViewBuilderLink getLink() {
        return this._link;
    }

    public void invalidate() {
        if (this._valid) {
            this._valid = false;
            this.firePropertyChange(PROPERTY_INVALID, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void validate(PaintContext context) {
        if (this._valid) {
            return;
        }
        this.validatePainter(context);
        this._valid = true;
    }

    public void cleanup() {
        this._removePropertyChangeListener();
        this._link = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport((Object)this);
        }
        this._support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(l);
        }
    }

    public Point getPoint(PaintContext context, Rectangle bounds) {
        if (bounds == null || bounds.isEmpty()) {
            return null;
        }
        Rectangle pBounds = this.getBounds(context);
        if (pBounds == null || !bounds.intersects(pBounds)) {
            return null;
        }
        Rectangle intersect = bounds.intersection(pBounds);
        int x = intersect.x;
        int y = intersect.y;
        if (this.contains(context, x, y)) {
            return new Point(x, y);
        }
        x = intersect.x + intersect.width;
        y = intersect.y;
        if (this.contains(context, x, y)) {
            return new Point(x, y);
        }
        x = intersect.x + intersect.width;
        y = intersect.y + intersect.height;
        if (this.contains(context, x, y)) {
            return new Point(x, y);
        }
        x = intersect.x;
        y = intersect.y + intersect.height;
        if (this.contains(context, x, y)) {
            return new Point(x, y);
        }
        return null;
    }

    protected void validatePainter(PaintContext context) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._support != null) {
            this._support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void _addPropertyChangeListener() {
        this._listener = new Invalidate();
        int count = this.getLink().getPortCount();
        for (int i = 0; i < count; ++i) {
            this.getLink().getSourcePort(i).addPropertyChangeListener(this._listener);
            this.getLink().getDestinationPort(i).addPropertyChangeListener(this._listener);
        }
    }

    private void _removePropertyChangeListener() {
        int count = this.getLink().getPortCount();
        for (int i = 0; i < count; ++i) {
            this.getLink().getSourcePort(i).removePropertyChangeListener(this._listener);
            this.getLink().getDestinationPort(i).removePropertyChangeListener(this._listener);
        }
        this._listener = null;
    }

    private class Invalidate
    implements PropertyChangeListener {
        private Invalidate() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("bounds".equals(name)) {
                ViewBuilderLinkPainter.this.invalidate();
            }
        }
    }
}

