/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.resultsTable;

import java.awt.Container;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.EmptyOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.table.SpreadTable;

class ResultsSpreadTable
extends SpreadTable {
    int _gridOrigin;
    int _headerOrigin;
    private TwoDModelListener _store = new DSStore();
    private TwoDModelListener _reset = new DSReset();

    public ResultsSpreadTable() {
        super(null, EmptyOneDModel.getOneDModel(), null);
        TwoDModel ds = this.getGrid().getModel();
        ds.addModelListener(this._store);
        ds.addModelListener(this._reset);
    }

    public void setModels(TwoDModel ds, OneDModel cds, OneDModel rds) {
        TwoDModel oldDS = this.getGrid().getModel();
        oldDS.removeModelListener(this._store);
        oldDS.removeModelListener(this._reset);
        if (ds == null) {
            ds = NullTwoDModel.getTwoDModel();
        }
        ds.addModelListener(this._store);
        super.setModels(ds, cds, rds);
        ds.addModelListener(this._reset);
    }

    void tryUpdateScrollBar() {
        if (this._gridOrigin == 0) {
            return;
        }
        Grid grid = this.getGrid();
        grid.setCanvasOrigin(this._gridOrigin, grid.getCanvasOriginY());
        Header header = this.getColumnHeader();
        header.setCanvasOrigin(this._headerOrigin, header.getCanvasOriginY());
        Container parent = this.getParent();
        if (parent instanceof LWComponent) {
            ((LWComponent)parent).unfreezeRepaints();
        }
        this.getParent().repaint();
        this._gridOrigin = 0;
    }

    private class DSReset
    extends TwoDModelAdapter {
        private DSReset() {
        }

        public void rowsAdded(TwoDModelEvent e) {
            ResultsSpreadTable.this.tryUpdateScrollBar();
        }
    }

    private class DSStore
    extends TwoDModelAdapter {
        private DSStore() {
        }

        public void rowsRemoved(TwoDModelEvent e) {
            if (e.getRowCount() == 0) {
                return;
            }
            Grid grid = ResultsSpreadTable.this.getGrid();
            if (grid.getRowCount() == 0) {
                ResultsSpreadTable.this._gridOrigin = grid.getCanvasOrigin().x;
                ResultsSpreadTable.this._headerOrigin = ResultsSpreadTable.this.getColumnHeader().getCanvasOrigin().x;
            }
        }

        public void rowsAdded(TwoDModelEvent e) {
            Container parent;
            if (ResultsSpreadTable.this._gridOrigin != 0 && (parent = ResultsSpreadTable.this.getParent()) instanceof LWComponent) {
                ((LWComponent)parent).freezeRepaints();
            }
        }
    }
}

