/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.laf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class DBUICheckPainter
extends AbstractBorderPainter {
    private static Painter _sPainter;
    private static final ImmInsets _sInsets;

    public static Painter getPainter() {
        if (_sPainter == null) {
            _sPainter = new DBUICheckPainter();
        }
        return _sPainter;
    }

    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 2;
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor(LookAndFeel.CONTROL);
        Color shadow = defaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        Color dark = defaults.getColor(LookAndFeel.DARK_INTENSITY);
        if ((state & 2) != 0) {
            g.setColor(dark);
            int temp1 = x;
            int temp2 = y;
            int temp3 = right;
            g.drawLine(temp1, y, temp3, y);
            g.drawLine(x, temp2, x, bottom);
        } else {
            g.setColor(shadow);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right, y, right, bottom);
            if ((state & 4) == 0) {
                g.setColor(Color.white);
                int temp1 = x;
                int temp2 = y;
                int temp3 = right;
                g.drawLine(temp1, y, temp3, y);
                g.drawLine(x, temp2, x, bottom);
                g.setColor(control);
                g.drawLine(x, bottom, x, bottom);
                g.drawLine(right, y, right, y);
            }
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private DBUICheckPainter() {
    }

    static {
        _sInsets = new ImmInsets(1, 1, 1, 1);
    }
}

