/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.scrolling;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Enumeration;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.EmptyBorder;
import oracle.bali.dbUI.graph.scrolling.ContinuousToolBarButton;
import oracle.bali.dbUI.graph.scrolling.NonFocusableButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

class ScrollToolbar
extends JToolBar
implements Adjustable,
ActionListener {
    private Scrollable _scrollable;
    private JViewport _viewport;
    private int _value;
    private int _maximum;
    private int _minimum;
    private int _orientation;
    private int _unitIncrement = 1;
    private int _blockIncrement = 10;
    private int _visible;
    private ListenerManager _listeners;
    private JButton _topButton;
    private JButton _upButton;
    private JButton _downButton;
    private JButton _bottomButton;
    private static final String _IS_ROLLOVER = "JToolBar.isRollover";

    public ScrollToolbar(JViewport viewport, Scrollable scrollable) {
        this._scrollable = scrollable;
        this._viewport = viewport;
        Image top = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/top.gif");
        Image topDisabled = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/top_disabled.gif");
        Image bottom = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/bottom.gif");
        Image bottomDisabled = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/bottom_disabled.gif");
        Image up = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/up.gif");
        Image upDisabled = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/up_disabled.gif");
        Image down = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/down.gif");
        Image downDisabled = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/down_disabled.gif");
        this._topButton = new NonFocusableButton(top);
        this._topButton.setDisabledIcon(new ImageIcon(topDisabled));
        this._bottomButton = new NonFocusableButton(bottom);
        this._bottomButton.setDisabledIcon(new ImageIcon(bottomDisabled));
        this._upButton = new ContinuousToolBarButton(up);
        this._upButton.setDisabledIcon(new ImageIcon(upDisabled));
        this._downButton = new ContinuousToolBarButton(down);
        this._downButton.setDisabledIcon(new ImageIcon(downDisabled));
        this.add(this._topButton);
        this.add(this._upButton);
        this.add(this._downButton);
        this.add(this._bottomButton);
        this._topButton.addActionListener(this);
        this._upButton.addActionListener(this);
        this._downButton.addActionListener(this);
        this._bottomButton.addActionListener(this);
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this._updateButtons();
        this.setOpaque(false);
        this.setBackground(null);
        this.putClientProperty(_IS_ROLLOVER, Boolean.TRUE);
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public int getValue() {
        return this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setValue(int newValue) {
        int maximum;
        int minimum;
        int visible;
        int value;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            value = newValue;
            visible = this._visible;
            minimum = this._minimum;
            maximum = this._maximum;
        }
        this.setValues(value, visible, minimum, maximum);
    }

    @Override
    public int getMinimum() {
        return this._minimum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMinimum(int newMinimum) {
        int maximum;
        int minimum;
        int visible;
        int value;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            value = this._value;
            visible = this._visible;
            minimum = newMinimum;
            maximum = this._maximum;
        }
        this.setValues(value, visible, minimum, maximum);
    }

    @Override
    public int getMaximum() {
        return this._maximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMaximum(int newMaximum) {
        int maximum;
        int minimum;
        int visible;
        int value;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            value = this._value;
            visible = this._visible;
            minimum = this._minimum;
            maximum = newMaximum;
        }
        this.setValues(value, visible, minimum, maximum);
    }

    @Override
    public int getVisibleAmount() {
        return this._visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisibleAmount(int newAmount) {
        int maximum;
        int minimum;
        int visible;
        int value;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            value = this._value;
            visible = newAmount;
            minimum = this._minimum;
            maximum = this._maximum;
        }
        this.setValues(value, visible, minimum, maximum);
    }

    @Override
    public synchronized void setUnitIncrement(int v) {
        this._unitIncrement = v;
    }

    @Override
    public int getUnitIncrement() {
        Rectangle vr = this._viewport.getViewRect();
        return this._scrollable.getScrollableUnitIncrement(vr, 1, 1);
    }

    @Override
    public synchronized void setBlockIncrement(int v) {
        this._blockIncrement = v;
    }

    @Override
    public int getBlockIncrement() {
        Rectangle vr = this._viewport.getViewRect();
        return this._scrollable.getScrollableBlockIncrement(vr, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int value, int visible, int minimum, int maximum) {
        int oldValue = this._value;
        ScrollToolbar scrollToolbar = this;
        synchronized (scrollToolbar) {
            if (value == this._value && visible == this._visible && minimum == this._minimum && maximum == this._maximum) {
                return;
            }
            this._setValuesInternal(value, visible, minimum, maximum);
        }
        if (oldValue != value) {
            this._fireAccessValue(oldValue, value);
        }
        this._updateButtons();
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener listener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)listener);
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener listener) {
        this._listeners.removeListener((EventListener)listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._topButton.setEnabled(enabled);
        this._upButton.setEnabled(enabled);
        this._downButton.setEnabled(enabled);
        this._bottomButton.setEnabled(enabled);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent e) {
        Enumeration enumer;
        ListenerManager listeners = this._listeners;
        if (listeners != null && (enumer = listeners.getListeners()) != null) {
            while (enumer.hasMoreElements()) {
                AdjustmentListener listener = (AdjustmentListener)enumer.nextElement();
                listener.adjustmentValueChanged(e);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int oldValue;
        Object item = e.getSource();
        int type = 5;
        int newValue = oldValue = this.getValue();
        if (this._topButton == item) {
            newValue = 0;
        } else if (this._bottomButton == item) {
            newValue = this.getMaximum() - this.getVisibleAmount();
        } else if (this._upButton == item) {
            newValue = oldValue - this.getUnitIncrement();
            type = 1;
        } else if (this._downButton == item) {
            newValue = oldValue + this.getUnitIncrement();
            type = 2;
        }
        this.setValue(newValue);
        if (oldValue != this.getValue()) {
            this.fireAdjustmentEvent(type);
        }
    }

    protected void fireAdjustmentEvent(int type) {
        this.processEvent(new AdjustmentEvent(this, 601, type, this.getValue()));
    }

    private synchronized void _setValuesInternal(int value, int visible, int minimum, int maximum) {
        if (maximum <= minimum) {
            maximum = minimum + 1;
        }
        if (visible > maximum - minimum) {
            visible = maximum - minimum;
        }
        if (visible < 1) {
            visible = 1;
        }
        if (value < minimum) {
            value = minimum;
        }
        if (value > maximum - visible) {
            value = maximum - visible;
        }
        this._value = value;
        this._visible = visible;
        this._minimum = minimum;
        this._maximum = maximum;
    }

    private void _updateButtons() {
        int value = this.getValue();
        int bottom = this.getMaximum() - this.getVisibleAmount() - value;
        this._topButton.setEnabled(value > 0);
        this._upButton.setEnabled(value > 0);
        this._bottomButton.setEnabled(bottom > 0);
        this._downButton.setEnabled(bottom > 0);
    }

    private void _fireAccessValue(int oldValue, int newValue) {
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ac.firePropertyChange("AccessibleValue", IntegerUtils.getInteger((int)oldValue), IntegerUtils.getInteger((int)newValue));
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        public Access() {
            super(ScrollToolbar.this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return null;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.VERTICAL);
            return states;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger((int)ScrollToolbar.this.getValue());
        }

        @Override
        public boolean setCurrentAccessibleValue(Number n) {
            ScrollToolbar.this.setValue(n.intValue());
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger((int)ScrollToolbar.this.getMinimum());
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger((int)ScrollToolbar.this.getMaximum());
        }
    }
}

