/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.db.event.DynamicTableListener;
import oracle.bali.share.event.ListenerManager;

public abstract class DynamicTable
extends Table {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DISPLAY_NAME = "displayName";
    private PropertyChangeSupport _support;
    private ListenerManager _listener;

    public abstract void setName(String var1);

    public abstract void addColumn(Column var1, int var2);

    public abstract void removeColumn(Column var1);

    public abstract void addForeignKey(Relationship var1, int var2);

    public abstract void removeForeignKey(Relationship var1);

    public abstract void addUniqueKey(Column var1, int var2);

    public abstract void removeUniqueKey(Column var1);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(listener);
        }
    }

    public void addTableListener(DynamicTableListener listener) {
        if (this._listener == null) {
            this._listener = new ListenerManager();
        }
        this._listener.addListener((EventListener)listener);
    }

    public void removeTableListener(DynamicTableListener listener) {
        if (this._listener != null) {
            this._listener.removeListener((EventListener)listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._support != null) {
            this._support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void fireTableEvent(int id, Column column, int index) {
        DynamicTableEvent e = new DynamicTableEvent(this, id, column, index);
        this.processTableEvent(e);
    }

    protected void fireTableEvent(int id, Relationship key, int index) {
        DynamicTableEvent e = new DynamicTableEvent(this, id, key, index);
        this.processTableEvent(e);
    }

    protected void processTableEvent(DynamicTableEvent e) {
        if (this._listener == null) {
            return;
        }
        Enumeration enumer = this._listener.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 100: {
                while (enumer.hasMoreElements()) {
                    ((DynamicTableListener)enumer.nextElement()).columnAdded(e);
                }
                break;
            }
            case 101: {
                while (enumer.hasMoreElements()) {
                    ((DynamicTableListener)enumer.nextElement()).columnRemoved(e);
                }
                break;
            }
            case 102: {
                while (enumer.hasMoreElements()) {
                    ((DynamicTableListener)enumer.nextElement()).primaryKeyAdded(e);
                }
                break;
            }
            case 103: {
                while (enumer.hasMoreElements()) {
                    ((DynamicTableListener)enumer.nextElement()).primaryKeyRemoved(e);
                }
                break;
            }
            case 104: {
                while (enumer.hasMoreElements()) {
                    ((DynamicTableListener)enumer.nextElement()).foreignKeyAdded(e);
                }
                break;
            }
            case 105: {
                while (enumer.hasMoreElements()) {
                    ((DynamicTableListener)enumer.nextElement()).foreignKeyRemoved(e);
                }
                break;
            }
            case 106: {
                while (enumer.hasMoreElements()) {
                    ((DynamicTableListener)enumer.nextElement()).uniqueKeyAdded(e);
                }
                break;
            }
            case 107: {
                while (enumer.hasMoreElements()) {
                    ((DynamicTableListener)enumer.nextElement()).uniqueKeyRemoved(e);
                }
                break;
            }
        }
    }
}

