/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraint;

import java.util.Vector;
import oracle.bali.dbUI.constraint.AndObjectTest;
import oracle.bali.dbUI.constraint.BetweenObjectTest;
import oracle.bali.dbUI.constraint.ContainsObjectTest;
import oracle.bali.dbUI.constraint.DCArithmeticExpression;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCBinaryExpression;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCCollectionExpression;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraint.EndsWithObjectTest;
import oracle.bali.dbUI.constraint.EqualToObjectTest;
import oracle.bali.dbUI.constraint.GreaterThanObjectTest;
import oracle.bali.dbUI.constraint.LessThanObjectTest;
import oracle.bali.dbUI.constraint.NaryObjectTest;
import oracle.bali.dbUI.constraint.NotObjectTest;
import oracle.bali.dbUI.constraint.OTAddExpression;
import oracle.bali.dbUI.constraint.OTBinaryExpression;
import oracle.bali.dbUI.constraint.OTConstant;
import oracle.bali.dbUI.constraint.OTDivideExpression;
import oracle.bali.dbUI.constraint.OTMultiplyExpression;
import oracle.bali.dbUI.constraint.OTName;
import oracle.bali.dbUI.constraint.OTSubtractExpression;
import oracle.bali.dbUI.constraint.ObjectTest;
import oracle.bali.dbUI.constraint.ObjectTestExpression;
import oracle.bali.dbUI.constraint.OrObjectTest;
import oracle.bali.dbUI.constraint.StartsWithObjectTest;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;

class ObjectTestGenerator {
    private DataDescriptorProvider _provider;

    public ObjectTestGenerator() {
        this(null);
    }

    public ObjectTestGenerator(DataDescriptorProvider provider) {
        this._provider = provider;
    }

    public void setDescriptorProvider(DataDescriptorProvider provider) {
        this._provider = provider;
    }

    public DataDescriptorProvider getDataDescriptorProvider() {
        return this._provider;
    }

    public ObjectTest getObjectTest(DataConstraint constraint) {
        ObjectTest ot = null;
        if (constraint == null) {
            return ot;
        }
        int operand = -1;
        if (constraint instanceof DCExpression) {
            operand = ((DCExpression)constraint).getOperand();
        }
        DataConstraint left = null;
        DataConstraint right = null;
        if (constraint instanceof DCBinaryExpression) {
            DCBinaryExpression binary = (DCBinaryExpression)constraint;
            left = binary.getConstraint(0);
            right = binary.getConstraint(1);
            if (!(left instanceof DCVariable) && right instanceof DCVariable) {
                DataConstraint temp = left;
                left = right;
                right = temp;
            }
        } else if (constraint instanceof DCUnaryExpression) {
            DCUnaryExpression unary = (DCUnaryExpression)constraint;
            left = unary.getConstraint(0);
        }
        if (constraint instanceof DCBooleanExpression) {
            ot = this._getBoolean((DCBooleanExpression)constraint);
        } else if (constraint instanceof DCUnaryExpression) {
            ObjectTest l = this.getObjectTest(left);
            ot = new NotObjectTest(l);
        } else if (constraint instanceof DCComparisonExpression) {
            ot = this._getComparison(left, right, operand);
        } else if (constraint instanceof DCCollectionExpression) {
            ot = this._getCollection(left, right, operand);
        } else if (constraint instanceof DCBetweenExpression) {
            ot = this._getBetween((DCBetweenExpression)constraint);
        }
        return ot;
    }

    private ObjectTest _getBoolean(DCBooleanExpression e) {
        int operand = e.getOperand();
        NaryObjectTest test = null;
        Vector<ObjectTest> testVector = new Vector<ObjectTest>();
        for (int i = 0; i < e.getConstraintCount(); ++i) {
            ObjectTest temp = this.getObjectTest(e.getConstraint(i));
            testVector.addElement(temp);
        }
        Object[] tests = new ObjectTest[testVector.size()];
        testVector.copyInto(tests);
        switch (operand) {
            case 1: {
                test = new AndObjectTest((ObjectTest[])tests);
                break;
            }
            case 2: {
                test = new OrObjectTest((ObjectTest[])tests);
            }
        }
        return test;
    }

    private ObjectTest _getComparison(DataConstraint left, DataConstraint right, int operand) {
        ObjectTest test = null;
        ObjectTestExpression le = this._getObjectTestExpression(left);
        ObjectTestExpression re = this._getObjectTestExpression(right);
        switch (operand) {
            case 1: {
                test = new GreaterThanObjectTest(le, re);
                break;
            }
            case 2: {
                test = new LessThanObjectTest(le, re);
                break;
            }
            case 3: {
                test = new EqualToObjectTest(le, re);
                break;
            }
            case 4: {
                test = new NotObjectTest(new EqualToObjectTest(le, re));
                break;
            }
            case 5: {
                ObjectTest[] temp = new ObjectTest[]{new GreaterThanObjectTest(le, re), new EqualToObjectTest(le, re)};
                test = new OrObjectTest(temp);
                break;
            }
            case 6: {
                ObjectTest[] temp = new ObjectTest[]{new LessThanObjectTest(le, re), new EqualToObjectTest(le, re)};
                test = new OrObjectTest(temp);
            }
        }
        return test;
    }

    private ObjectTest _getCollection(DataConstraint left, DataConstraint right, int operand) {
        ObjectTest test = null;
        ObjectTestExpression le = this._getObjectTestExpression(left);
        ObjectTestExpression re = this._getObjectTestExpression(right);
        switch (operand) {
            case 1: {
                test = new StartsWithObjectTest(le, re, false);
                break;
            }
            case 2: {
                test = new StartsWithObjectTest(le, re, true);
                break;
            }
            case 3: {
                test = new EndsWithObjectTest(le, re, false);
                break;
            }
            case 4: {
                test = new EndsWithObjectTest(le, re, true);
                break;
            }
            case 5: {
                test = new ContainsObjectTest(le, re);
                break;
            }
            case 6: {
                test = new NotObjectTest(new ContainsObjectTest(le, re));
            }
        }
        return test;
    }

    private ObjectTestExpression _getArithmetic(DataConstraint left, DataConstraint right, int operand) {
        OTBinaryExpression e = null;
        ObjectTestExpression l = this._getObjectTestExpression(left);
        ObjectTestExpression r = this._getObjectTestExpression(right);
        switch (operand) {
            case 1: {
                e = new OTAddExpression(l, r);
                break;
            }
            case 2: {
                e = new OTSubtractExpression(l, r);
                break;
            }
            case 3: {
                e = new OTMultiplyExpression(l, r);
                break;
            }
            case 4: {
                e = new OTDivideExpression(l, r);
            }
        }
        return e;
    }

    private ObjectTest _getBetween(DCBetweenExpression e) {
        int operand = e.getOperand();
        ObjectTestExpression check = this._getObjectTestExpression(e.getCheckConstraint());
        ObjectTestExpression first = this._getObjectTestExpression(e.getFirstConstraint());
        ObjectTestExpression second = this._getObjectTestExpression(e.getSecondConstraint());
        boolean not = operand == 2;
        return new BetweenObjectTest(check, first, second, not);
    }

    private ObjectTestExpression _getObjectTestExpression(DataConstraint constraint) {
        ObjectTestExpression e = null;
        DataConstraint left = null;
        DataConstraint right = null;
        DCBinaryExpression binary = null;
        if (constraint instanceof DCBinaryExpression) {
            binary = (DCBinaryExpression)constraint;
            left = binary.getConstraint(0);
            right = binary.getConstraint(1);
        }
        if (constraint instanceof DCVariable) {
            e = this._createName((DCVariable)constraint);
        } else if (constraint instanceof DCConstant) {
            e = this._createConstant((DCConstant)constraint);
        } else if (constraint instanceof DCArithmeticExpression) {
            int operand = ((DCArithmeticExpression)constraint).getOperand();
            e = this._getArithmetic(left, right, operand);
        }
        return e;
    }

    private ObjectTestExpression _createName(DCVariable n) {
        DataDescriptorProvider p = this.getDataDescriptorProvider();
        if (p == null) {
            return null;
        }
        Object o = n.getVariable();
        String name = o instanceof DataDescriptor ? ((DataDescriptor)o).getName() : null;
        int index = -1;
        int count = p.getDescriptorCount();
        for (int i = 0; i < count; ++i) {
            DataDescriptor temp = p.getDescriptor(i);
            if (!temp.equals(o) && !temp.getName().equals(name)) continue;
            index = i;
            break;
        }
        return index == -1 ? null : new OTName(index);
    }

    private ObjectTestExpression _createConstant(DCConstant cons) {
        return new OTConstant(cons.getValue());
    }
}

