/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;

final class DebugJDIClassLoaderInfo
extends JDIInformationProvider
implements DebugClassLoaderInfo {
    private DebugJDI dj;
    private ClassLoaderReference clr;
    private boolean parentKnown;
    private DebugJDIClassLoaderInfo parent;
    private String className;
    private int id;
    private int hashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugJDIClassLoaderInfo makeClassLoaderInfo(DebugJDI dj, ClassLoaderReference clr) {
        Map map = dj.classLoaderInfos;
        synchronized (map) {
            Object key = clr != null ? clr : "BootstrapClassLoader";
            DebugJDIClassLoaderInfo classLoaderInfo = (DebugJDIClassLoaderInfo)((Object)dj.classLoaderInfos.get(key));
            if (classLoaderInfo == null) {
                classLoaderInfo = new DebugJDIClassLoaderInfo(dj, clr);
                dj.classLoaderInfos.put(key, classLoaderInfo);
                classLoaderInfo.explore();
            }
            return classLoaderInfo;
        }
    }

    private DebugJDIClassLoaderInfo(DebugJDI dj, ClassLoaderReference clr) {
        this.dj = dj;
        this.clr = clr;
        if (clr != null) {
            this.className = clr.referenceType().name();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explore() {
        if (this.clr != null && !this.className.equals("sun.reflect.DelegatingClassLoader")) {
            DebugShared.exploreClassLoaderParents((DebugClassLoaderInfo)this);
        }
        Map map = this.dj.classLoaderIds;
        synchronized (map) {
            Integer lastId = (Integer)this.dj.classLoaderIds.get(this.className);
            this.id = lastId == null ? 1 : lastId + 1;
            lastId = new Integer(this.id);
            this.dj.classLoaderIds.put(this.className, lastId);
        }
    }

    public boolean hasExpired() {
        return this.clr != null && this.dj.isObjectCollected(this.clr);
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    public String getClassName() {
        this.throwIfExpired();
        return this.className;
    }

    public int getId() {
        this.throwIfExpired();
        return this.id;
    }

    public DebugClassInfo[] listDefinedClasses() {
        this.throwIfExpired();
        ArrayList<DebugJDIClassInfo> v = new ArrayList<DebugJDIClassInfo>();
        if (this.clr != null) {
            List<ReferenceType> definedClasses = this.clr.definedClasses();
            int size = definedClasses.size();
            for (int i = 0; i < size; ++i) {
                ReferenceType rt = definedClasses.get(i);
                DebugJDIClassInfo ci = this.dj.findClass(rt);
                if (ci == null) continue;
                v.add(ci);
            }
        } else {
            for (DebugJDIClassInfo ci : this.dj.classesByReferenceType.values()) {
                if (ci.getClassLoaderReference() != null) continue;
                v.add(ci);
            }
        }
        DebugClassInfo[] array = new DebugClassInfo[v.size()];
        return v.toArray(array);
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        this.throwIfExpired();
        try {
            if (this.clr != null) {
                return (DebugDataObjectInfo)this.dj.makeData(this.clr, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public DebugClassLoaderInfo getParent() {
        this.throwIfExpired();
        if (this.clr != null) {
            if (!this.parentKnown) {
                ClassLoaderReference clrParent;
                DebugJDIDataObjectInfo dataClassLoaderParent;
                DebugDataObjectInfo dataClassLoaderObject = this.getClassLoaderObject();
                if (dataClassLoaderObject != null && (dataClassLoaderParent = (DebugJDIDataObjectInfo)DebugShared.getParentClassLoaderObject((DebugDataObjectInfo)dataClassLoaderObject)) != null && (clrParent = (ClassLoaderReference)dataClassLoaderParent.value) != null) {
                    this.parent = DebugJDIClassLoaderInfo.makeClassLoaderInfo(this.dj, clrParent);
                }
                this.parentKnown = true;
            }
            return this.parent;
        }
        return null;
    }

    public boolean isSystemClassLoader() {
        return this.clr != null && this.clr == this.dj.getSystemClassLoader();
    }

    public int hashCode() {
        if (this.hashCode == 0 && this.clr != null) {
            this.hashCode = this.clr.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIClassLoaderInfo) {
            DebugJDIClassLoaderInfo other = (DebugJDIClassLoaderInfo)((Object)o);
            return this.clr == null ? other.clr == null : this.clr.equals(other.clr);
        }
        return false;
    }

    public Value getJDIValue() {
        return this.clr;
    }
}

