/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import oracle.ide.model.Node;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointStreamBCOp;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.jdi.StreamDebuggingManager;
import oracle.jdevimpl.debugger.plugin.StreamDebugger;
import oracle.jdevimpl.debugger.support.CodeExecutionBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointIntermediateStreamOperation;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStepType;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.runner.debug.streams.StreamOperationExpressionInfo;

public class DebugJDIBreakpointStreamIntermediateBCOp
extends DebugJDIBreakpointStreamBCOp
implements DebugBreakpointIntermediateStreamOperation,
CodeExecutionBreakpoint {
    private StreamOperationExpressionInfo info;
    private Log streamsLogger = StreamDebugger.getLogger();
    private boolean VERBOSE = false;

    public DebugJDIBreakpointStreamIntermediateBCOp(DebugJDI dj, String method, int bytecodeOffset) {
        super(dj, method, bytecodeOffset);
    }

    public void setExpressionInfo(StreamOperationExpressionInfo info) {
        this.info = info;
    }

    public void executeAfterStop() {
        this.streamsLogger.trace("DebugJDIBreakpointStreamIntermediateBCOp executeAfterStop() invoked");
        this.streamsLogger.trace("    [argument collector for " + this.info.getLineNumber() + ":" + this.info.getText() + "]");
        DebugJDIThreadInfo thread = (DebugJDIThreadInfo)this.dj.getCurrentThread();
        DebugStackFrameInfo frame = thread.getStackFrame(0);
        if (frame == null) {
            this.streamsLogger.trace("  executeAfterStop has null frame, exit without recording anything");
            return;
        }
        DebugLocation location = frame.getLocation();
        Node node = this.context.getNode();
        long threadID = thread.getThreadId();
        this.streamsLogger.trace("    executeAfterStop @ " + location.getLine() + ": " + location.getMethod().getNameWithoutClass() + " bytecode offset " + location.getBytecodeOffset());
        DebugVariableInfo[] a = frame.listArguments();
        if (a.length > 0) {
            if (this.VERBOSE) {
                this.streamsLogger.trace(a.length + " arguments: ");
            }
            for (DebugVariableInfo var : a) {
                DebugDataInfo ddi = var.getDataInfo();
                String value = null;
                if (ddi instanceof DebugDataCompositeInfo) {
                    DebugDataCompositeInfo ddci = (DebugDataCompositeInfo)ddi;
                    value = ddci.getCourtesyValue();
                }
                if (value == null || value.equals("null")) {
                    if (!this.VERBOSE) continue;
                    this.streamsLogger.trace("    Will not record: " + var.getName() + " because " + value);
                    continue;
                }
                StreamDebuggingManager.getInstance().recordArgument(node, threadID, location.getLine(), this.info.getLambdaArgumentHelperMethodName(), this.info.getText(), var.getName(), value);
                this.streamsLogger.trace("    executeAfterStop recorded argument value " + this.info.getText() + " = " + value);
            }
        }
        String stoppedInMethod = location.getMethod().getNameWithoutClassOrSignature();
        this.streamsLogger.trace("    executeAfterStop stopped in " + stoppedInMethod);
        if (stoppedInMethod.startsWith("lambda$")) {
            if (this.dj.isRunCommandQueued(DebugJDI.RunCommand.StepOut)) {
                this.streamsLogger.trace("    bp hit in lambda, step out already pending, won't queue another");
            } else {
                this.streamsLogger.trace("    executeAfterStop done recording args, enqueuing StepOut to capture return value");
                this.dj.addRunCommandToQueue(DebugJDI.RunCommand.StepOut);
            }
        }
        this.dj.makeMethodExitRequestForStepOut(thread.tr);
        this.dj.setReturnValueCollectorForStepOut(this);
    }

    public void executeAfterStep(DebugStepType type) {
        if (type == DebugStepType.STEP_OUT) {
            this.executeAtMethodExit(this.dj.getCurrentThread(), "end of run loop (via executeAfterStep)");
        }
    }

    public void executeAtMethodExit(DebugThreadInfo thread, String calledFrom) {
        this.streamsLogger.trace("executeAtMethodExit for operation " + this.info.getText() + " called from " + calledFrom);
        if (thread == null) {
            this.streamsLogger.trace(" -- null currentThread, cannot get RV");
        }
        if (thread.getReturnedValue() != null) {
            DebugDataInfo data;
            DebugVariableInfo var;
            Node node = this.context.getNode();
            long threadID = thread.getThreadId();
            DebugStackFrameInfo frame = thread.getStackFrame(0);
            if (thread != null && frame != null && frame.getFrameNumber() == 0 && (var = thread.getReturnedValue()) != null && (data = var.getDataInfo()) != null) {
                if (data instanceof DebugDataCompositeInfo) {
                    String name = var.getName();
                    String value = ((DebugDataCompositeInfo)data).getCourtesyValue();
                    StreamDebuggingManager.getInstance().recordReturnValue(node, threadID, this.info.getLambdaArgumentHelperMethodName(), value);
                    this.streamsLogger.trace("  Recorded composite return value " + name + " = " + value);
                } else if (data instanceof DebugDataPrimitiveInfo) {
                    String name = var.getName();
                    String value = ((DebugDataPrimitiveInfo)data).getValue();
                    StreamDebuggingManager.getInstance().recordReturnValue(node, threadID, this.info.getLambdaArgumentHelperMethodName(), value);
                    this.streamsLogger.trace("  Recorded primitive return value " + name + " = " + value);
                } else {
                    this.streamsLogger.trace(" Did not capture return value because type not handled " + data.getClass().getName());
                }
            }
        }
    }
}

