/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.migration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.naming.Referenceable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdeveloper.db.migration.ConnectionsInfo;
import oracle.jdevimpl.db.migration.AbstractDBMigrator;

public class ConnectionMigrator
extends AbstractDBMigrator {
    private static final String CM_CONNECTIONS_FILE = "IDEConnections.xml";
    private static final String CONNECTIONS_FILE_NAME = "connections.xml";
    private static URL s_migrationURL;
    private static boolean s_cmMigration;

    @Override
    protected String getExtensionID() {
        return "oracle.jdeveloper.db.connection";
    }

    public String[] migrate(File sourceDir, File destDir) {
        String[] result = new String[]{};
        File src = this.getConnectionsFile(sourceDir);
        if (src == null) {
            src = this.getOldConnectionsFile(sourceDir);
        }
        if (src != null) {
            URL sourceURL = URLFactory.newFileURL((File)src);
            try {
                ConnectionsInfo info = ConnectionsInfo.getConnectionsInfo(sourceURL);
                if (!(info.isLegacyCMFormat() || !info.requiresPassphrase() && info.containsPasswords())) {
                    URL targetURL = URLFactory.newURL((URL)URLFactory.newDirURL((File)destDir), (String)CONNECTIONS_FILE_NAME);
                    try {
                        URLFileSystem.copy((URL)sourceURL, (URL)targetURL);
                    }
                    catch (IOException ioe) {
                        result = new String[]{"Connection migration failed: " + ioe.getMessage()};
                    }
                } else if (s_migrationURL == null) {
                    s_migrationURL = sourceURL;
                    s_cmMigration = info.isLegacyCMFormat();
                } else {
                    ConnectionMigrator.getLogger().severe("Migration URL already exists, cannot replace!");
                }
            }
            catch (ConnectionException ce) {
                result = new String[]{ce.getMessage()};
            }
        }
        return result;
    }

    public boolean canMigrate(int category, File sourceDir) {
        return this.getConnectionsFile(sourceDir) != null || this.getOldConnectionsFile(sourceDir) != null;
    }

    private File getConnectionsFile(File sourceDir) {
        return this.findExtensionFile(sourceDir, CONNECTIONS_FILE_NAME);
    }

    private File getOldConnectionsFile(File sourceDir) {
        return this.findExtensionFile(sourceDir, new String[]{"oracle.onlinedb", "oracle.j2ee"}, CM_CONNECTIONS_FILE);
    }

    public static void finishMigration(DatabaseConnections conns) {
        if (s_migrationURL != null) {
            if (s_cmMigration) {
                CMConnectionsReader reader = new CMConnectionsReader(s_migrationURL.getFile(), true);
                Map<String, Referenceable> oldConns = reader.getMigratedConnections();
                for (Map.Entry<String, Referenceable> entry : oldConns.entrySet()) {
                    String name = entry.getKey();
                    try {
                        conns.addConnection(name, ((DatabaseProvider)entry.getValue()).getProperties());
                    }
                    catch (ConnectionException ce) {
                        ConnectionMigrator.getLogger().severe("Migration of " + name + " failed: " + ce.getMessage());
                    }
                }
            } else {
                DatabaseConnections oldConns = DatabaseConnections.getPrivateInstance(s_migrationURL, null);
                for (String name : oldConns.listConnections()) {
                    try {
                        Properties props = oldConns.getProperties(name);
                        conns.addConnection(name, props);
                    }
                    catch (ConnectionException ne) {
                        ConnectionMigrator.getLogger().severe("Migration of " + name + " failed: " + ne.getMessage());
                    }
                }
            }
            try {
                conns.saveConnections();
            }
            catch (ConnectionException ce) {
                ConnectionMigrator.getLogger().severe("Connection migration failed: " + ce.getMessage());
            }
        }
        s_migrationURL = null;
    }
}

