/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DisconnectListener;

public abstract class DatabaseConnectionsListener
implements ConnectionsListener,
DisconnectListener {
    @Override
    public void connectionAdded(ConnectionsEvent event) {
    }

    @Override
    public void connectionRemoved(ConnectionsEvent event) {
    }

    @Override
    public void connectionUpdated(ConnectionsEvent event) {
    }

    @Override
    public boolean canDisconnect(ConnectionsEvent event) {
        return true;
    }

    @Override
    public void connectionDisconnected(ConnectionsEvent event) {
    }

    public void connectionConnected(ConnectionsEvent event, ConnectionType type) {
    }

    static DatabaseConnectionsListener adapt(DisconnectListener dl) {
        return dl instanceof DatabaseConnectionsListener ? (DatabaseConnectionsListener)dl : new DisconnectAdapter(dl);
    }

    static DatabaseConnectionsListener adapt(ConnectionsListener cl) {
        return cl instanceof DatabaseConnectionsListener ? (DatabaseConnectionsListener)cl : new ConnectionsAdapter(cl);
    }

    private static class ConnectionsAdapter
    extends DatabaseConnectionsListener {
        private final ConnectionsListener m_cl;

        ConnectionsAdapter(ConnectionsListener cl) {
            this.m_cl = cl;
        }

        @Override
        public void connectionAdded(ConnectionsEvent event) {
            this.m_cl.connectionAdded(event);
        }

        @Override
        public void connectionRemoved(ConnectionsEvent event) {
            this.m_cl.connectionRemoved(event);
        }

        @Override
        public void connectionUpdated(ConnectionsEvent event) {
            this.m_cl.connectionUpdated(event);
        }

        public boolean equals(Object obj) {
            return obj instanceof ConnectionsAdapter && this.m_cl.equals(((ConnectionsAdapter)obj).m_cl);
        }

        public int hashCode() {
            return this.m_cl.hashCode();
        }
    }

    private static class DisconnectAdapter
    extends DatabaseConnectionsListener {
        private final DisconnectListener m_dl;

        DisconnectAdapter(DisconnectListener dl) {
            this.m_dl = dl;
        }

        @Override
        public boolean canDisconnect(ConnectionsEvent event) {
            return this.m_dl.canDisconnect(event);
        }

        @Override
        public void connectionDisconnected(ConnectionsEvent event) {
            this.m_dl.connectionDisconnected(event);
        }

        public boolean equals(Object obj) {
            return obj instanceof DisconnectAdapter && this.m_dl.equals(((DisconnectAdapter)obj).m_dl);
        }

        public int hashCode() {
            return this.m_dl.hashCode();
        }
    }

    public static enum ConnectionType {
        CONNECT,
        RECONNECT,
        UNIQUE;

    }
}

