/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.Properties;
import oracle.ide.Context;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.resource.ConnBundle;

public abstract class DatabaseConnectionEditorLauncher {
    private StoreChoice m_storeChoice = StoreChoice.CONTEXT;
    private Properties m_defaultProps;
    private String m_baseName;
    private Context m_context;
    private String[] m_subTypes;
    private boolean m_ensureVisible;
    private boolean m_allowRename;

    public final void setEnsureVisible(boolean ensureVisible) {
        this.m_ensureVisible = ensureVisible;
    }

    public final boolean getEnsureVisible() {
        return this.m_ensureVisible;
    }

    public final void setAllowRename(boolean allowRename) {
        this.m_allowRename = allowRename;
    }

    public final boolean getAllowRename() {
        return this.m_allowRename;
    }

    public final void setAllowedSubTypes(String[] subTypes) {
        this.m_subTypes = subTypes;
    }

    public final String[] getAllowedSubTypes() {
        return this.m_subTypes;
    }

    protected final boolean isAllowedSubType(String subType) {
        boolean retval = true;
        if (this.m_subTypes != null) {
            retval = false;
            for (String allowed : this.m_subTypes) {
                if (!ModelUtil.areEqual((Object)allowed, (Object)subType)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    public final void setStoreChoice(StoreChoice choice) {
        if (choice != null) {
            this.m_storeChoice = choice;
        }
    }

    public final StoreChoice getStoreChoice() {
        return this.m_storeChoice;
    }

    public final void setContext(Context context) {
        this.m_context = context;
    }

    protected Context getContext() {
        return this.m_context == null ? Context.newIdeContext() : this.m_context;
    }

    public final void setDefautProperties(Properties props) {
        this.m_defaultProps = props;
    }

    protected final Properties getDefaultProperties() {
        return this.m_defaultProps;
    }

    public final void setConnectionBaseName(String baseName) {
        this.m_baseName = baseName;
    }

    protected String getConnectionBaseName() {
        return ModelUtil.hasLength((String)this.m_baseName) ? this.m_baseName : ConnBundle.get("DEFAULT_CONN_NAME");
    }

    public final String launchEditor(String connName) {
        return this.launchEditor((String)null, connName);
    }

    public final String launchEditor(String storeName, String connName) {
        ConnectionInfo info;
        DatabaseConnections conns = null;
        if (ModelUtil.hasLength((String)storeName)) {
            conns = DatabaseConnectionStores.getInstance().getStore(storeName);
        }
        return (info = this.launchEditor(conns, connName)) == null ? null : info.getConnectionName();
    }

    public final ConnectionInfo launchEditor(ConnectionInfo info) {
        DatabaseConnections conns = null;
        if (info != null) {
            conns = DatabaseConnectionStores.getInstance().getStore(info.getStoreName());
        }
        return this.launchEditor(conns, info == null ? null : info.getConnectionName());
    }

    public abstract ConnectionInfo launchEditor(DatabaseConnections var1, String var2);

    public static enum StoreChoice {
        NONE,
        CONTEXT,
        ALL;

    }
}

